package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcFirewallDefaultIPSConfig invokes the cloudfw.DescribeVpcFirewallDefaultIPSConfig API synchronously
func (client *Client) DescribeVpcFirewallDefaultIPSConfig(request *DescribeVpcFirewallDefaultIPSConfigRequest) (response *DescribeVpcFirewallDefaultIPSConfigResponse, err error) {
	response = CreateDescribeVpcFirewallDefaultIPSConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcFirewallDefaultIPSConfigWithChan invokes the cloudfw.DescribeVpcFirewallDefaultIPSConfig API asynchronously
func (client *Client) DescribeVpcFirewallDefaultIPSConfigWithChan(request *DescribeVpcFirewallDefaultIPSConfigRequest) (<-chan *DescribeVpcFirewallDefaultIPSConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcFirewallDefaultIPSConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcFirewallDefaultIPSConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcFirewallDefaultIPSConfigWithCallback invokes the cloudfw.DescribeVpcFirewallDefaultIPSConfig API asynchronously
func (client *Client) DescribeVpcFirewallDefaultIPSConfigWithCallback(request *DescribeVpcFirewallDefaultIPSConfigRequest, callback func(response *DescribeVpcFirewallDefaultIPSConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcFirewallDefaultIPSConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcFirewallDefaultIPSConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcFirewallDefaultIPSConfigRequest is the request struct for api DescribeVpcFirewallDefaultIPSConfig
type DescribeVpcFirewallDefaultIPSConfigRequest struct {
	*requests.RpcRequest
	SourceIp      string `position:"Query" name:"SourceIp"`
	MemberUid     string `position:"Query" name:"MemberUid"`
	VpcFirewallId string `position:"Query" name:"VpcFirewallId"`
}

// DescribeVpcFirewallDefaultIPSConfigResponse is the response struct for api DescribeVpcFirewallDefaultIPSConfig
type DescribeVpcFirewallDefaultIPSConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	RunMode        int    `json:"RunMode" xml:"RunMode"`
	EnableAllPatch int    `json:"EnableAllPatch" xml:"EnableAllPatch"`
	BasicRules     int    `json:"BasicRules" xml:"BasicRules"`
}

// CreateDescribeVpcFirewallDefaultIPSConfigRequest creates a request to invoke DescribeVpcFirewallDefaultIPSConfig API
func CreateDescribeVpcFirewallDefaultIPSConfigRequest() (request *DescribeVpcFirewallDefaultIPSConfigRequest) {
	request = &DescribeVpcFirewallDefaultIPSConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVpcFirewallDefaultIPSConfig", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcFirewallDefaultIPSConfigResponse creates a response to parse from DescribeVpcFirewallDefaultIPSConfig response
func CreateDescribeVpcFirewallDefaultIPSConfigResponse() (response *DescribeVpcFirewallDefaultIPSConfigResponse) {
	response = &DescribeVpcFirewallDefaultIPSConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
