package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAddressBook invokes the cloudfw.DescribeAddressBook API synchronously
func (client *Client) DescribeAddressBook(request *DescribeAddressBookRequest) (response *DescribeAddressBookResponse, err error) {
	response = CreateDescribeAddressBookResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAddressBookWithChan invokes the cloudfw.DescribeAddressBook API asynchronously
func (client *Client) DescribeAddressBookWithChan(request *DescribeAddressBookRequest) (<-chan *DescribeAddressBookResponse, <-chan error) {
	responseChan := make(chan *DescribeAddressBookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAddressBook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAddressBookWithCallback invokes the cloudfw.DescribeAddressBook API asynchronously
func (client *Client) DescribeAddressBookWithCallback(request *DescribeAddressBookRequest, callback func(response *DescribeAddressBookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAddressBookResponse
		var err error
		defer close(result)
		response, err = client.DescribeAddressBook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAddressBookRequest is the request struct for api DescribeAddressBook
type DescribeAddressBookRequest struct {
	*requests.RpcRequest
	GroupType   string `position:"Query" name:"GroupType"`
	SourceIp    string `position:"Query" name:"SourceIp"`
	PageSize    string `position:"Query" name:"PageSize"`
	Lang        string `position:"Query" name:"Lang"`
	Query       string `position:"Query" name:"Query"`
	CurrentPage string `position:"Query" name:"CurrentPage"`
	ContainPort string `position:"Query" name:"ContainPort"`
}

// DescribeAddressBookResponse is the response struct for api DescribeAddressBook
type DescribeAddressBookResponse struct {
	*responses.BaseResponse
	PageNo     string `json:"PageNo" xml:"PageNo"`
	PageSize   string `json:"PageSize" xml:"PageSize"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount string `json:"TotalCount" xml:"TotalCount"`
	Acls       []Acl  `json:"Acls" xml:"Acls"`
}

// CreateDescribeAddressBookRequest creates a request to invoke DescribeAddressBook API
func CreateDescribeAddressBookRequest() (request *DescribeAddressBookRequest) {
	request = &DescribeAddressBookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeAddressBook", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAddressBookResponse creates a response to parse from DescribeAddressBook response
func CreateDescribeAddressBookResponse() (response *DescribeAddressBookResponse) {
	response = &DescribeAddressBookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
