package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRandomNumbers invokes the cloudcallcenter.QueryRandomNumbers API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryrandomnumbers.html
func (client *Client) QueryRandomNumbers(request *QueryRandomNumbersRequest) (response *QueryRandomNumbersResponse, err error) {
	response = CreateQueryRandomNumbersResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRandomNumbersWithChan invokes the cloudcallcenter.QueryRandomNumbers API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryrandomnumbers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRandomNumbersWithChan(request *QueryRandomNumbersRequest) (<-chan *QueryRandomNumbersResponse, <-chan error) {
	responseChan := make(chan *QueryRandomNumbersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRandomNumbers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRandomNumbersWithCallback invokes the cloudcallcenter.QueryRandomNumbers API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryrandomnumbers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRandomNumbersWithCallback(request *QueryRandomNumbersRequest, callback func(response *QueryRandomNumbersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRandomNumbersResponse
		var err error
		defer close(result)
		response, err = client.QueryRandomNumbers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRandomNumbersRequest is the request struct for api QueryRandomNumbers
type QueryRandomNumbersRequest struct {
	*requests.RpcRequest
	SpecId       requests.Integer `position:"Query" name:"SpecId"`
	RemainCount  requests.Integer `position:"Query" name:"RemainCount"`
	Province     string           `position:"Query" name:"Province"`
	City         string           `position:"Query" name:"City"`
	OrderId      requests.Integer `position:"Query" name:"OrderId"`
	MonthlyPrice requests.Integer `position:"Query" name:"MonthlyPrice"`
}

// QueryRandomNumbersResponse is the response struct for api QueryRandomNumbers
type QueryRandomNumbersResponse struct {
	*responses.BaseResponse
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Success        bool                     `json:"Success" xml:"Success"`
	Code           string                   `json:"Code" xml:"Code"`
	Message        string                   `json:"Message" xml:"Message"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInQueryRandomNumbers `json:"Data" xml:"Data"`
}

// CreateQueryRandomNumbersRequest creates a request to invoke QueryRandomNumbers API
func CreateQueryRandomNumbersRequest() (request *QueryRandomNumbersRequest) {
	request = &QueryRandomNumbersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryRandomNumbers", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRandomNumbersResponse creates a response to parse from QueryRandomNumbers response
func CreateQueryRandomNumbersResponse() (response *QueryRandomNumbersResponse) {
	response = &QueryRandomNumbersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
