package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Log invokes the cloudcallcenter.Log API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/log.html
func (client *Client) Log(request *LogRequest) (response *LogResponse, err error) {
	response = CreateLogResponse()
	err = client.DoAction(request, response)
	return
}

// LogWithChan invokes the cloudcallcenter.Log API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/log.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LogWithChan(request *LogRequest) (<-chan *LogResponse, <-chan error) {
	responseChan := make(chan *LogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Log(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LogWithCallback invokes the cloudcallcenter.Log API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/log.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LogWithCallback(request *LogRequest, callback func(response *LogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LogResponse
		var err error
		defer close(result)
		response, err = client.Log(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LogRequest is the request struct for api Log
type LogRequest struct {
	*requests.RpcRequest
	Message    string `position:"Query" name:"Message"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// LogResponse is the response struct for api Log
type LogResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateLogRequest creates a request to invoke Log API
func CreateLogRequest() (request *LogRequest) {
	request = &LogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "Log", "", "")
	request.Method = requests.POST
	return
}

// CreateLogResponse creates a response to parse from Log response
func CreateLogResponse() (response *LogResponse) {
	response = &LogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
