package bpstudio

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseApplication invokes the bpstudio.ReleaseApplication API synchronously
func (client *Client) ReleaseApplication(request *ReleaseApplicationRequest) (response *ReleaseApplicationResponse, err error) {
	response = CreateReleaseApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseApplicationWithChan invokes the bpstudio.ReleaseApplication API asynchronously
func (client *Client) ReleaseApplicationWithChan(request *ReleaseApplicationRequest) (<-chan *ReleaseApplicationResponse, <-chan error) {
	responseChan := make(chan *ReleaseApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseApplicationWithCallback invokes the bpstudio.ReleaseApplication API asynchronously
func (client *Client) ReleaseApplicationWithCallback(request *ReleaseApplicationRequest, callback func(response *ReleaseApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseApplicationResponse
		var err error
		defer close(result)
		response, err = client.ReleaseApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseApplicationRequest is the request struct for api ReleaseApplication
type ReleaseApplicationRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
	ApplicationId   string `position:"Body" name:"ApplicationId"`
}

// ReleaseApplicationResponse is the response struct for api ReleaseApplication
type ReleaseApplicationResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateReleaseApplicationRequest creates a request to invoke ReleaseApplication API
func CreateReleaseApplicationRequest() (request *ReleaseApplicationRequest) {
	request = &ReleaseApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BPStudio", "2021-09-31", "ReleaseApplication", "bpstudio", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseApplicationResponse creates a response to parse from ReleaseApplication response
func CreateReleaseApplicationResponse() (response *ReleaseApplicationResponse) {
	response = &ReleaseApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
