package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainLatestTransactionDigests invokes the baas.DescribeAntChainLatestTransactionDigests API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchainlatesttransactiondigests.html
func (client *Client) DescribeAntChainLatestTransactionDigests(request *DescribeAntChainLatestTransactionDigestsRequest) (response *DescribeAntChainLatestTransactionDigestsResponse, err error) {
	response = CreateDescribeAntChainLatestTransactionDigestsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainLatestTransactionDigestsWithChan invokes the baas.DescribeAntChainLatestTransactionDigests API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainlatesttransactiondigests.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainLatestTransactionDigestsWithChan(request *DescribeAntChainLatestTransactionDigestsRequest) (<-chan *DescribeAntChainLatestTransactionDigestsResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainLatestTransactionDigestsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainLatestTransactionDigests(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainLatestTransactionDigestsWithCallback invokes the baas.DescribeAntChainLatestTransactionDigests API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainlatesttransactiondigests.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainLatestTransactionDigestsWithCallback(request *DescribeAntChainLatestTransactionDigestsRequest, callback func(response *DescribeAntChainLatestTransactionDigestsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainLatestTransactionDigestsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainLatestTransactionDigests(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainLatestTransactionDigestsRequest is the request struct for api DescribeAntChainLatestTransactionDigests
type DescribeAntChainLatestTransactionDigestsRequest struct {
	*requests.RpcRequest
	AntChainId string `position:"Body" name:"AntChainId"`
}

// DescribeAntChainLatestTransactionDigestsResponse is the response struct for api DescribeAntChainLatestTransactionDigests
type DescribeAntChainLatestTransactionDigestsResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Result    []map[string]interface{} `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainLatestTransactionDigestsRequest creates a request to invoke DescribeAntChainLatestTransactionDigests API
func CreateDescribeAntChainLatestTransactionDigestsRequest() (request *DescribeAntChainLatestTransactionDigestsRequest) {
	request = &DescribeAntChainLatestTransactionDigestsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainLatestTransactionDigests", "baas", "openAPI")
	return
}

// CreateDescribeAntChainLatestTransactionDigestsResponse creates a response to parse from DescribeAntChainLatestTransactionDigests response
func CreateDescribeAntChainLatestTransactionDigestsResponse() (response *DescribeAntChainLatestTransactionDigestsResponse) {
	response = &DescribeAntChainLatestTransactionDigestsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
