package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManageGetRecordingRule invokes the arms.ManageGetRecordingRule API synchronously
func (client *Client) ManageGetRecordingRule(request *ManageGetRecordingRuleRequest) (response *ManageGetRecordingRuleResponse, err error) {
	response = CreateManageGetRecordingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ManageGetRecordingRuleWithChan invokes the arms.ManageGetRecordingRule API asynchronously
func (client *Client) ManageGetRecordingRuleWithChan(request *ManageGetRecordingRuleRequest) (<-chan *ManageGetRecordingRuleResponse, <-chan error) {
	responseChan := make(chan *ManageGetRecordingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManageGetRecordingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManageGetRecordingRuleWithCallback invokes the arms.ManageGetRecordingRule API asynchronously
func (client *Client) ManageGetRecordingRuleWithCallback(request *ManageGetRecordingRuleRequest, callback func(response *ManageGetRecordingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManageGetRecordingRuleResponse
		var err error
		defer close(result)
		response, err = client.ManageGetRecordingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManageGetRecordingRuleRequest is the request struct for api ManageGetRecordingRule
type ManageGetRecordingRuleRequest struct {
	*requests.RpcRequest
	QueryUserId string `position:"Query" name:"QueryUserId"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// ManageGetRecordingRuleResponse is the response struct for api ManageGetRecordingRule
type ManageGetRecordingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateManageGetRecordingRuleRequest creates a request to invoke ManageGetRecordingRule API
func CreateManageGetRecordingRuleRequest() (request *ManageGetRecordingRuleRequest) {
	request = &ManageGetRecordingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ManageGetRecordingRule", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateManageGetRecordingRuleResponse creates a response to parse from ManageGetRecordingRule response
func CreateManageGetRecordingRuleResponse() (response *ManageGetRecordingRuleResponse) {
	response = &ManageGetRecordingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
