package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePrometheusRemoteWrite invokes the arms.DeletePrometheusRemoteWrite API synchronously
func (client *Client) DeletePrometheusRemoteWrite(request *DeletePrometheusRemoteWriteRequest) (response *DeletePrometheusRemoteWriteResponse, err error) {
	response = CreateDeletePrometheusRemoteWriteResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePrometheusRemoteWriteWithChan invokes the arms.DeletePrometheusRemoteWrite API asynchronously
func (client *Client) DeletePrometheusRemoteWriteWithChan(request *DeletePrometheusRemoteWriteRequest) (<-chan *DeletePrometheusRemoteWriteResponse, <-chan error) {
	responseChan := make(chan *DeletePrometheusRemoteWriteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePrometheusRemoteWrite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePrometheusRemoteWriteWithCallback invokes the arms.DeletePrometheusRemoteWrite API asynchronously
func (client *Client) DeletePrometheusRemoteWriteWithCallback(request *DeletePrometheusRemoteWriteRequest, callback func(response *DeletePrometheusRemoteWriteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePrometheusRemoteWriteResponse
		var err error
		defer close(result)
		response, err = client.DeletePrometheusRemoteWrite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePrometheusRemoteWriteRequest is the request struct for api DeletePrometheusRemoteWrite
type DeletePrometheusRemoteWriteRequest struct {
	*requests.RpcRequest
	RemoteWriteNames string `position:"Query" name:"RemoteWriteNames"`
	ClusterId        string `position:"Query" name:"ClusterId"`
}

// DeletePrometheusRemoteWriteResponse is the response struct for api DeletePrometheusRemoteWrite
type DeletePrometheusRemoteWriteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateDeletePrometheusRemoteWriteRequest creates a request to invoke DeletePrometheusRemoteWrite API
func CreateDeletePrometheusRemoteWriteRequest() (request *DeletePrometheusRemoteWriteRequest) {
	request = &DeletePrometheusRemoteWriteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeletePrometheusRemoteWrite", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePrometheusRemoteWriteResponse creates a response to parse from DeletePrometheusRemoteWrite response
func CreateDeletePrometheusRemoteWriteResponse() (response *DeletePrometheusRemoteWriteResponse) {
	response = &DeletePrometheusRemoteWriteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
