package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVirtualHost invokes the amqp_open.CreateVirtualHost API synchronously
func (client *Client) CreateVirtualHost(request *CreateVirtualHostRequest) (response *CreateVirtualHostResponse, err error) {
	response = CreateCreateVirtualHostResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVirtualHostWithChan invokes the amqp_open.CreateVirtualHost API asynchronously
func (client *Client) CreateVirtualHostWithChan(request *CreateVirtualHostRequest) (<-chan *CreateVirtualHostResponse, <-chan error) {
	responseChan := make(chan *CreateVirtualHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVirtualHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVirtualHostWithCallback invokes the amqp_open.CreateVirtualHost API asynchronously
func (client *Client) CreateVirtualHostWithCallback(request *CreateVirtualHostRequest, callback func(response *CreateVirtualHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVirtualHostResponse
		var err error
		defer close(result)
		response, err = client.CreateVirtualHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVirtualHostRequest is the request struct for api CreateVirtualHost
type CreateVirtualHostRequest struct {
	*requests.RpcRequest
	InstanceId  string `position:"Body" name:"InstanceId"`
	VirtualHost string `position:"Body" name:"VirtualHost"`
}

// CreateVirtualHostResponse is the response struct for api CreateVirtualHost
type CreateVirtualHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateVirtualHostRequest creates a request to invoke CreateVirtualHost API
func CreateCreateVirtualHostRequest() (request *CreateVirtualHostRequest) {
	request = &CreateVirtualHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "CreateVirtualHost", "onsproxy", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVirtualHostResponse creates a response to parse from CreateVirtualHost response
func CreateCreateVirtualHostResponse() (response *CreateVirtualHostResponse) {
	response = &CreateVirtualHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
