package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestFe invokes the amp.TestFe API synchronously
func (client *Client) TestFe(request *TestFeRequest) (response *TestFeResponse, err error) {
	response = CreateTestFeResponse()
	err = client.DoAction(request, response)
	return
}

// TestFeWithChan invokes the amp.TestFe API asynchronously
func (client *Client) TestFeWithChan(request *TestFeRequest) (<-chan *TestFeResponse, <-chan error) {
	responseChan := make(chan *TestFeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestFe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestFeWithCallback invokes the amp.TestFe API asynchronously
func (client *Client) TestFeWithCallback(request *TestFeRequest, callback func(response *TestFeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestFeResponse
		var err error
		defer close(result)
		response, err = client.TestFe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestFeRequest is the request struct for api TestFe
type TestFeRequest struct {
	*requests.RoaRequest
	Add1 string `position:"Query" name:"Add1"`
}

// TestFeResponse is the response struct for api TestFe
type TestFeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateTestFeRequest creates a request to invoke TestFe API
func CreateTestFeRequest() (request *TestFeRequest) {
	request = &TestFeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "TestFe", "/efe/333", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTestFeResponse creates a response to parse from TestFe response
func CreateTestFeResponse() (response *TestFeResponse) {
	response = &TestFeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
