package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetGtmMonitorStatus invokes the alidns.SetGtmMonitorStatus API synchronously
func (client *Client) SetGtmMonitorStatus(request *SetGtmMonitorStatusRequest) (response *SetGtmMonitorStatusResponse, err error) {
	response = CreateSetGtmMonitorStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetGtmMonitorStatusWithChan invokes the alidns.SetGtmMonitorStatus API asynchronously
func (client *Client) SetGtmMonitorStatusWithChan(request *SetGtmMonitorStatusRequest) (<-chan *SetGtmMonitorStatusResponse, <-chan error) {
	responseChan := make(chan *SetGtmMonitorStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetGtmMonitorStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetGtmMonitorStatusWithCallback invokes the alidns.SetGtmMonitorStatus API asynchronously
func (client *Client) SetGtmMonitorStatusWithCallback(request *SetGtmMonitorStatusRequest, callback func(response *SetGtmMonitorStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetGtmMonitorStatusResponse
		var err error
		defer close(result)
		response, err = client.SetGtmMonitorStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetGtmMonitorStatusRequest is the request struct for api SetGtmMonitorStatus
type SetGtmMonitorStatusRequest struct {
	*requests.RpcRequest
	MonitorConfigId string `position:"Query" name:"MonitorConfigId"`
	UserClientIp    string `position:"Query" name:"UserClientIp"`
	Lang            string `position:"Query" name:"Lang"`
	Status          string `position:"Query" name:"Status"`
}

// SetGtmMonitorStatusResponse is the response struct for api SetGtmMonitorStatus
type SetGtmMonitorStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetGtmMonitorStatusRequest creates a request to invoke SetGtmMonitorStatus API
func CreateSetGtmMonitorStatusRequest() (request *SetGtmMonitorStatusRequest) {
	request = &SetGtmMonitorStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "SetGtmMonitorStatus", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetGtmMonitorStatusResponse creates a response to parse from SetGtmMonitorStatus response
func CreateSetGtmMonitorStatusResponse() (response *SetGtmMonitorStatusResponse) {
	response = &SetGtmMonitorStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
