package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmInstanceAddressPool invokes the alidns.DescribeDnsGtmInstanceAddressPool API synchronously
func (client *Client) DescribeDnsGtmInstanceAddressPool(request *DescribeDnsGtmInstanceAddressPoolRequest) (response *DescribeDnsGtmInstanceAddressPoolResponse, err error) {
	response = CreateDescribeDnsGtmInstanceAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmInstanceAddressPoolWithChan invokes the alidns.DescribeDnsGtmInstanceAddressPool API asynchronously
func (client *Client) DescribeDnsGtmInstanceAddressPoolWithChan(request *DescribeDnsGtmInstanceAddressPoolRequest) (<-chan *DescribeDnsGtmInstanceAddressPoolResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmInstanceAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmInstanceAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmInstanceAddressPoolWithCallback invokes the alidns.DescribeDnsGtmInstanceAddressPool API asynchronously
func (client *Client) DescribeDnsGtmInstanceAddressPoolWithCallback(request *DescribeDnsGtmInstanceAddressPoolRequest, callback func(response *DescribeDnsGtmInstanceAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmInstanceAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmInstanceAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmInstanceAddressPoolRequest is the request struct for api DescribeDnsGtmInstanceAddressPool
type DescribeDnsGtmInstanceAddressPoolRequest struct {
	*requests.RpcRequest
	AddrPoolId   string `position:"Query" name:"AddrPoolId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmInstanceAddressPoolResponse is the response struct for api DescribeDnsGtmInstanceAddressPool
type DescribeDnsGtmInstanceAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId       string                                   `json:"RequestId" xml:"RequestId"`
	LbaStrategy     string                                   `json:"LbaStrategy" xml:"LbaStrategy"`
	CreateTime      string                                   `json:"CreateTime" xml:"CreateTime"`
	AddrCount       int                                      `json:"AddrCount" xml:"AddrCount"`
	Name            string                                   `json:"Name" xml:"Name"`
	Type            string                                   `json:"Type" xml:"Type"`
	UpdateTime      string                                   `json:"UpdateTime" xml:"UpdateTime"`
	AddrPoolId      string                                   `json:"AddrPoolId" xml:"AddrPoolId"`
	UpdateTimestamp int64                                    `json:"UpdateTimestamp" xml:"UpdateTimestamp"`
	MonitorConfigId string                                   `json:"MonitorConfigId" xml:"MonitorConfigId"`
	MonitorStatus   string                                   `json:"MonitorStatus" xml:"MonitorStatus"`
	CreateTimestamp int64                                    `json:"CreateTimestamp" xml:"CreateTimestamp"`
	Addrs           AddrsInDescribeDnsGtmInstanceAddressPool `json:"Addrs" xml:"Addrs"`
}

// CreateDescribeDnsGtmInstanceAddressPoolRequest creates a request to invoke DescribeDnsGtmInstanceAddressPool API
func CreateDescribeDnsGtmInstanceAddressPoolRequest() (request *DescribeDnsGtmInstanceAddressPoolRequest) {
	request = &DescribeDnsGtmInstanceAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmInstanceAddressPool", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmInstanceAddressPoolResponse creates a response to parse from DescribeDnsGtmInstanceAddressPool response
func CreateDescribeDnsGtmInstanceAddressPoolResponse() (response *DescribeDnsGtmInstanceAddressPoolResponse) {
	response = &DescribeDnsGtmInstanceAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
