package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExperimentMetas invokes the ahas_openapi.ListExperimentMetas API synchronously
func (client *Client) ListExperimentMetas(request *ListExperimentMetasRequest) (response *ListExperimentMetasResponse, err error) {
	response = CreateListExperimentMetasResponse()
	err = client.DoAction(request, response)
	return
}

// ListExperimentMetasWithChan invokes the ahas_openapi.ListExperimentMetas API asynchronously
func (client *Client) ListExperimentMetasWithChan(request *ListExperimentMetasRequest) (<-chan *ListExperimentMetasResponse, <-chan error) {
	responseChan := make(chan *ListExperimentMetasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExperimentMetas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExperimentMetasWithCallback invokes the ahas_openapi.ListExperimentMetas API asynchronously
func (client *Client) ListExperimentMetasWithCallback(request *ListExperimentMetasRequest, callback func(response *ListExperimentMetasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExperimentMetasResponse
		var err error
		defer close(result)
		response, err = client.ListExperimentMetas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExperimentMetasRequest is the request struct for api ListExperimentMetas
type ListExperimentMetasRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	Size         requests.Integer `position:"Query" name:"Size"`
	NameSpace    string           `position:"Query" name:"NameSpace"`
	Page         requests.Integer `position:"Query" name:"Page"`
}

// ListExperimentMetasResponse is the response struct for api ListExperimentMetas
type ListExperimentMetasResponse struct {
	*responses.BaseResponse
	Pages       int           `json:"Pages" xml:"Pages"`
	RequestId   string        `json:"RequestId" xml:"RequestId"`
	Message     string        `json:"Message" xml:"Message"`
	PageSize    int           `json:"PageSize" xml:"PageSize"`
	CurrentPage int           `json:"CurrentPage" xml:"CurrentPage"`
	Total       int           `json:"Total" xml:"Total"`
	Code        string        `json:"Code" xml:"Code"`
	Success     bool          `json:"Success" xml:"Success"`
	Content     []ContentItem `json:"Content" xml:"Content"`
}

// CreateListExperimentMetasRequest creates a request to invoke ListExperimentMetas API
func CreateListExperimentMetasRequest() (request *ListExperimentMetasRequest) {
	request = &ListExperimentMetasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListExperimentMetas", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListExperimentMetasResponse creates a response to parse from ListExperimentMetas response
func CreateListExperimentMetasResponse() (response *ListExperimentMetasResponse) {
	response = &ListExperimentMetasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
