package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIsolationRule invokes the ahas_openapi.CreateIsolationRule API synchronously
func (client *Client) CreateIsolationRule(request *CreateIsolationRuleRequest) (response *CreateIsolationRuleResponse, err error) {
	response = CreateCreateIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIsolationRuleWithChan invokes the ahas_openapi.CreateIsolationRule API asynchronously
func (client *Client) CreateIsolationRuleWithChan(request *CreateIsolationRuleRequest) (<-chan *CreateIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *CreateIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIsolationRuleWithCallback invokes the ahas_openapi.CreateIsolationRule API asynchronously
func (client *Client) CreateIsolationRuleWithCallback(request *CreateIsolationRuleRequest, callback func(response *CreateIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIsolationRuleRequest is the request struct for api CreateIsolationRule
type CreateIsolationRuleRequest struct {
	*requests.RpcRequest
	RefResource      string           `position:"Query" name:"RefResource"`
	Resource         string           `position:"Query" name:"Resource"`
	Threshold        requests.Float   `position:"Query" name:"Threshold"`
	AhasRegionId     string           `position:"Query" name:"AhasRegionId"`
	LimitOrigin      string           `position:"Query" name:"LimitOrigin"`
	AppName          string           `position:"Query" name:"AppName"`
	Enable           requests.Boolean `position:"Query" name:"Enable"`
	Namespace        string           `position:"Query" name:"Namespace"`
	RelationStrategy requests.Integer `position:"Query" name:"RelationStrategy"`
}

// CreateIsolationRuleResponse is the response struct for api CreateIsolationRule
type CreateIsolationRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateIsolationRuleRequest creates a request to invoke CreateIsolationRule API
func CreateCreateIsolationRuleRequest() (request *CreateIsolationRuleRequest) {
	request = &CreateIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "CreateIsolationRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIsolationRuleResponse creates a response to parse from CreateIsolationRule response
func CreateCreateIsolationRuleResponse() (response *CreateIsolationRuleResponse) {
	response = &CreateIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
