package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScreenSummaryInfo invokes the aegis.DescribeScreenSummaryInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describescreensummaryinfo.html
func (client *Client) DescribeScreenSummaryInfo(request *DescribeScreenSummaryInfoRequest) (response *DescribeScreenSummaryInfoResponse, err error) {
	response = CreateDescribeScreenSummaryInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScreenSummaryInfoWithChan invokes the aegis.DescribeScreenSummaryInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreensummaryinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenSummaryInfoWithChan(request *DescribeScreenSummaryInfoRequest) (<-chan *DescribeScreenSummaryInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeScreenSummaryInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScreenSummaryInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScreenSummaryInfoWithCallback invokes the aegis.DescribeScreenSummaryInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreensummaryinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenSummaryInfoWithCallback(request *DescribeScreenSummaryInfoRequest, callback func(response *DescribeScreenSummaryInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScreenSummaryInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeScreenSummaryInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScreenSummaryInfoRequest is the request struct for api DescribeScreenSummaryInfo
type DescribeScreenSummaryInfoRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeScreenSummaryInfoResponse is the response struct for api DescribeScreenSummaryInfo
type DescribeScreenSummaryInfoResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	AegisClientOfflineCount int    `json:"AegisClientOfflineCount" xml:"AegisClientOfflineCount"`
	SecurityScore           int    `json:"SecurityScore" xml:"SecurityScore"`
	AegisClientOnlineCount  int    `json:"AegisClientOnlineCount" xml:"AegisClientOnlineCount"`
	Success                 bool   `json:"Success" xml:"Success"`
}

// CreateDescribeScreenSummaryInfoRequest creates a request to invoke DescribeScreenSummaryInfo API
func CreateDescribeScreenSummaryInfoRequest() (request *DescribeScreenSummaryInfoRequest) {
	request = &DescribeScreenSummaryInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeScreenSummaryInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeScreenSummaryInfoResponse creates a response to parse from DescribeScreenSummaryInfo response
func CreateDescribeScreenSummaryInfoResponse() (response *DescribeScreenSummaryInfoResponse) {
	response = &DescribeScreenSummaryInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
