package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateExpressConnectTrafficQos invokes the vpc.CreateExpressConnectTrafficQos API synchronously
func (client *Client) CreateExpressConnectTrafficQos(request *CreateExpressConnectTrafficQosRequest) (response *CreateExpressConnectTrafficQosResponse, err error) {
	response = CreateCreateExpressConnectTrafficQosResponse()
	err = client.DoAction(request, response)
	return
}

// CreateExpressConnectTrafficQosWithChan invokes the vpc.CreateExpressConnectTrafficQos API asynchronously
func (client *Client) CreateExpressConnectTrafficQosWithChan(request *CreateExpressConnectTrafficQosRequest) (<-chan *CreateExpressConnectTrafficQosResponse, <-chan error) {
	responseChan := make(chan *CreateExpressConnectTrafficQosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateExpressConnectTrafficQos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateExpressConnectTrafficQosWithCallback invokes the vpc.CreateExpressConnectTrafficQos API asynchronously
func (client *Client) CreateExpressConnectTrafficQosWithCallback(request *CreateExpressConnectTrafficQosRequest, callback func(response *CreateExpressConnectTrafficQosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateExpressConnectTrafficQosResponse
		var err error
		defer close(result)
		response, err = client.CreateExpressConnectTrafficQos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateExpressConnectTrafficQosRequest is the request struct for api CreateExpressConnectTrafficQos
type CreateExpressConnectTrafficQosRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	QosName              string           `position:"Query" name:"QosName"`
	QosDescription       string           `position:"Query" name:"QosDescription"`
}

// CreateExpressConnectTrafficQosResponse is the response struct for api CreateExpressConnectTrafficQos
type CreateExpressConnectTrafficQosResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	QosId     string `json:"QosId" xml:"QosId"`
}

// CreateCreateExpressConnectTrafficQosRequest creates a request to invoke CreateExpressConnectTrafficQos API
func CreateCreateExpressConnectTrafficQosRequest() (request *CreateExpressConnectTrafficQosRequest) {
	request = &CreateExpressConnectTrafficQosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateExpressConnectTrafficQos", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateExpressConnectTrafficQosResponse creates a response to parse from CreateExpressConnectTrafficQos response
func CreateCreateExpressConnectTrafficQosResponse() (response *CreateExpressConnectTrafficQosResponse) {
	response = &CreateExpressConnectTrafficQosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
