package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAppInfo invokes the vod.CreateAppInfo API synchronously
func (client *Client) CreateAppInfo(request *CreateAppInfoRequest) (response *CreateAppInfoResponse, err error) {
	response = CreateCreateAppInfoResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAppInfoWithChan invokes the vod.CreateAppInfo API asynchronously
func (client *Client) CreateAppInfoWithChan(request *CreateAppInfoRequest) (<-chan *CreateAppInfoResponse, <-chan error) {
	responseChan := make(chan *CreateAppInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAppInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAppInfoWithCallback invokes the vod.CreateAppInfo API asynchronously
func (client *Client) CreateAppInfoWithCallback(request *CreateAppInfoRequest, callback func(response *CreateAppInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAppInfoResponse
		var err error
		defer close(result)
		response, err = client.CreateAppInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAppInfoRequest is the request struct for api CreateAppInfo
type CreateAppInfoRequest struct {
	*requests.RpcRequest
	Description         string           `position:"Query" name:"Description"`
	ResourceRealOwnerId requests.Integer `position:"Query" name:"ResourceRealOwnerId"`
	ResourceGroupId     string           `position:"Query" name:"ResourceGroupId"`
	AppName             string           `position:"Query" name:"AppName"`
}

// CreateAppInfoResponse is the response struct for api CreateAppInfo
type CreateAppInfoResponse struct {
	*responses.BaseResponse
	AppId     string `json:"AppId" xml:"AppId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAppInfoRequest creates a request to invoke CreateAppInfo API
func CreateCreateAppInfoRequest() (request *CreateAppInfoRequest) {
	request = &CreateAppInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "CreateAppInfo", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAppInfoResponse creates a response to parse from CreateAppInfo response
func CreateCreateAppInfoResponse() (response *CreateAppInfoResponse) {
	response = &CreateAppInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
