package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTenantBizConfig invokes the unimkt.QueryTenantBizConfig API synchronously
func (client *Client) QueryTenantBizConfig(request *QueryTenantBizConfigRequest) (response *QueryTenantBizConfigResponse, err error) {
	response = CreateQueryTenantBizConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTenantBizConfigWithChan invokes the unimkt.QueryTenantBizConfig API asynchronously
func (client *Client) QueryTenantBizConfigWithChan(request *QueryTenantBizConfigRequest) (<-chan *QueryTenantBizConfigResponse, <-chan error) {
	responseChan := make(chan *QueryTenantBizConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTenantBizConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTenantBizConfigWithCallback invokes the unimkt.QueryTenantBizConfig API asynchronously
func (client *Client) QueryTenantBizConfigWithCallback(request *QueryTenantBizConfigRequest, callback func(response *QueryTenantBizConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTenantBizConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryTenantBizConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTenantBizConfigRequest is the request struct for api QueryTenantBizConfig
type QueryTenantBizConfigRequest struct {
	*requests.RpcRequest
	Environment      string `position:"Query" name:"Environment"`
	Business         string `position:"Query" name:"Business"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	BizId            string `position:"Query" name:"BizId"`
	UserSite         string `position:"Query" name:"UserSite"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
}

// QueryTenantBizConfigResponse is the response struct for api QueryTenantBizConfig
type QueryTenantBizConfigResponse struct {
	*responses.BaseResponse
	Code      string   `json:"Code" xml:"Code"`
	Success   bool     `json:"Success" xml:"Success"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Model     []Config `json:"Model" xml:"Model"`
}

// CreateQueryTenantBizConfigRequest creates a request to invoke QueryTenantBizConfig API
func CreateQueryTenantBizConfigRequest() (request *QueryTenantBizConfigRequest) {
	request = &QueryTenantBizConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryTenantBizConfig", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTenantBizConfigResponse creates a response to parse from QueryTenantBizConfig response
func CreateQueryTenantBizConfigResponse() (response *QueryTenantBizConfigResponse) {
	response = &QueryTenantBizConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
