package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTemplate invokes the retailadvqa_public.AddTemplate API synchronously
func (client *Client) AddTemplate(request *AddTemplateRequest) (response *AddTemplateResponse, err error) {
	response = CreateAddTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// AddTemplateWithChan invokes the retailadvqa_public.AddTemplate API asynchronously
func (client *Client) AddTemplateWithChan(request *AddTemplateRequest) (<-chan *AddTemplateResponse, <-chan error) {
	responseChan := make(chan *AddTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTemplateWithCallback invokes the retailadvqa_public.AddTemplate API asynchronously
func (client *Client) AddTemplateWithCallback(request *AddTemplateRequest, callback func(response *AddTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTemplateResponse
		var err error
		defer close(result)
		response, err = client.AddTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTemplateRequest is the request struct for api AddTemplate
type AddTemplateRequest struct {
	*requests.RpcRequest
	AccessId        string           `position:"Query" name:"AccessId"`
	TemplateContent string           `position:"Query" name:"TemplateContent"`
	IsVariable      requests.Integer `position:"Query" name:"IsVariable"`
	TemplateType    requests.Integer `position:"Query" name:"TemplateType"`
	TenantId        string           `position:"Query" name:"TenantId"`
	Comefrom        string           `position:"Query" name:"Comefrom"`
	TemplateName    string           `position:"Query" name:"TemplateName"`
	Remark          string           `position:"Query" name:"Remark"`
	PlatformIds     string           `position:"Query" name:"PlatformIds"`
	WorkspaceId     string           `position:"Query" name:"WorkspaceId"`
}

// AddTemplateResponse is the response struct for api AddTemplate
type AddTemplateResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ExStack   string `json:"ExStack" xml:"ExStack"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddTemplateRequest creates a request to invoke AddTemplate API
func CreateAddTemplateRequest() (request *AddTemplateRequest) {
	request = &AddTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "AddTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateAddTemplateResponse creates a response to parse from AddTemplate response
func CreateAddTemplateResponse() (response *AddTemplateResponse) {
	response = &AddTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
