package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceCounts invokes the resourcecenter.GetResourceCounts API synchronously
func (client *Client) GetResourceCounts(request *GetResourceCountsRequest) (response *GetResourceCountsResponse, err error) {
	response = CreateGetResourceCountsResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceCountsWithChan invokes the resourcecenter.GetResourceCounts API asynchronously
func (client *Client) GetResourceCountsWithChan(request *GetResourceCountsRequest) (<-chan *GetResourceCountsResponse, <-chan error) {
	responseChan := make(chan *GetResourceCountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceCounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceCountsWithCallback invokes the resourcecenter.GetResourceCounts API asynchronously
func (client *Client) GetResourceCountsWithCallback(request *GetResourceCountsRequest, callback func(response *GetResourceCountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceCountsResponse
		var err error
		defer close(result)
		response, err = client.GetResourceCounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceCountsRequest is the request struct for api GetResourceCounts
type GetResourceCountsRequest struct {
	*requests.RpcRequest
	Filter     *[]GetResourceCountsFilter `position:"Query" name:"Filter"  type:"Repeated"`
	View       string                     `position:"Query" name:"View"`
	GroupByKey string                     `position:"Query" name:"GroupByKey"`
}

// GetResourceCountsFilter is a repeated param struct in GetResourceCountsRequest
type GetResourceCountsFilter struct {
	MatchType string    `name:"MatchType"`
	Value     *[]string `name:"Value" type:"Repeated"`
	Key       string    `name:"Key"`
}

// GetResourceCountsResponse is the response struct for api GetResourceCounts
type GetResourceCountsResponse struct {
	*responses.BaseResponse
	GroupByKey     string          `json:"GroupByKey" xml:"GroupByKey"`
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	Filters        []Filter        `json:"Filters" xml:"Filters"`
	ResourceCounts []ResourceCount `json:"ResourceCounts" xml:"ResourceCounts"`
}

// CreateGetResourceCountsRequest creates a request to invoke GetResourceCounts API
func CreateGetResourceCountsRequest() (request *GetResourceCountsRequest) {
	request = &GetResourceCountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "GetResourceCounts", "", "")
	request.Method = requests.POST
	return
}

// CreateGetResourceCountsResponse creates a response to parse from GetResourceCounts response
func CreateGetResourceCountsResponse() (response *GetResourceCountsResponse) {
	response = &GetResourceCountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
