package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateDefaultFilter invokes the resourcecenter.AssociateDefaultFilter API synchronously
func (client *Client) AssociateDefaultFilter(request *AssociateDefaultFilterRequest) (response *AssociateDefaultFilterResponse, err error) {
	response = CreateAssociateDefaultFilterResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateDefaultFilterWithChan invokes the resourcecenter.AssociateDefaultFilter API asynchronously
func (client *Client) AssociateDefaultFilterWithChan(request *AssociateDefaultFilterRequest) (<-chan *AssociateDefaultFilterResponse, <-chan error) {
	responseChan := make(chan *AssociateDefaultFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateDefaultFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateDefaultFilterWithCallback invokes the resourcecenter.AssociateDefaultFilter API asynchronously
func (client *Client) AssociateDefaultFilterWithCallback(request *AssociateDefaultFilterRequest, callback func(response *AssociateDefaultFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateDefaultFilterResponse
		var err error
		defer close(result)
		response, err = client.AssociateDefaultFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateDefaultFilterRequest is the request struct for api AssociateDefaultFilter
type AssociateDefaultFilterRequest struct {
	*requests.RpcRequest
	FilterName string `position:"Query" name:"FilterName"`
}

// AssociateDefaultFilterResponse is the response struct for api AssociateDefaultFilter
type AssociateDefaultFilterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateDefaultFilterRequest creates a request to invoke AssociateDefaultFilter API
func CreateAssociateDefaultFilterRequest() (request *AssociateDefaultFilterRequest) {
	request = &AssociateDefaultFilterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "AssociateDefaultFilter", "", "")
	request.Method = requests.POST
	return
}

// CreateAssociateDefaultFilterResponse creates a response to parse from AssociateDefaultFilter response
func CreateAssociateDefaultFilterResponse() (response *AssociateDefaultFilterResponse) {
	response = &AssociateDefaultFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
