package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUserTagValue invokes the quickbi_public.UpdateUserTagValue API synchronously
func (client *Client) UpdateUserTagValue(request *UpdateUserTagValueRequest) (response *UpdateUserTagValueResponse, err error) {
	response = CreateUpdateUserTagValueResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUserTagValueWithChan invokes the quickbi_public.UpdateUserTagValue API asynchronously
func (client *Client) UpdateUserTagValueWithChan(request *UpdateUserTagValueRequest) (<-chan *UpdateUserTagValueResponse, <-chan error) {
	responseChan := make(chan *UpdateUserTagValueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUserTagValue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUserTagValueWithCallback invokes the quickbi_public.UpdateUserTagValue API asynchronously
func (client *Client) UpdateUserTagValueWithCallback(request *UpdateUserTagValueRequest, callback func(response *UpdateUserTagValueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUserTagValueResponse
		var err error
		defer close(result)
		response, err = client.UpdateUserTagValue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUserTagValueRequest is the request struct for api UpdateUserTagValue
type UpdateUserTagValueRequest struct {
	*requests.RpcRequest
	TagValue    string `position:"Query" name:"TagValue"`
	TagId       string `position:"Query" name:"TagId"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
}

// UpdateUserTagValueResponse is the response struct for api UpdateUserTagValue
type UpdateUserTagValueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateUserTagValueRequest creates a request to invoke UpdateUserTagValue API
func CreateUpdateUserTagValueRequest() (request *UpdateUserTagValueRequest) {
	request = &UpdateUserTagValueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "UpdateUserTagValue", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateUserTagValueResponse creates a response to parse from UpdateUserTagValue response
func CreateUpdateUserTagValueResponse() (response *UpdateUserTagValueResponse) {
	response = &UpdateUserTagValueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
