package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSchemeTaskConfig invokes the qualitycheck.CreateSchemeTaskConfig API synchronously
func (client *Client) CreateSchemeTaskConfig(request *CreateSchemeTaskConfigRequest) (response *CreateSchemeTaskConfigResponse, err error) {
	response = CreateCreateSchemeTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSchemeTaskConfigWithChan invokes the qualitycheck.CreateSchemeTaskConfig API asynchronously
func (client *Client) CreateSchemeTaskConfigWithChan(request *CreateSchemeTaskConfigRequest) (<-chan *CreateSchemeTaskConfigResponse, <-chan error) {
	responseChan := make(chan *CreateSchemeTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSchemeTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSchemeTaskConfigWithCallback invokes the qualitycheck.CreateSchemeTaskConfig API asynchronously
func (client *Client) CreateSchemeTaskConfigWithCallback(request *CreateSchemeTaskConfigRequest, callback func(response *CreateSchemeTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSchemeTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateSchemeTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSchemeTaskConfigRequest is the request struct for api CreateSchemeTaskConfig
type CreateSchemeTaskConfigRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// CreateSchemeTaskConfigResponse is the response struct for api CreateSchemeTaskConfig
type CreateSchemeTaskConfigResponse struct {
	*responses.BaseResponse
	Data           int64                            `json:"Data" xml:"Data"`
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	Success        bool                             `json:"Success" xml:"Success"`
	Code           string                           `json:"Code" xml:"Code"`
	Message        string                           `json:"Message" xml:"Message"`
	HttpStatusCode int                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInCreateSchemeTaskConfig `json:"Messages" xml:"Messages"`
}

// CreateCreateSchemeTaskConfigRequest creates a request to invoke CreateSchemeTaskConfig API
func CreateCreateSchemeTaskConfigRequest() (request *CreateSchemeTaskConfigRequest) {
	request = &CreateSchemeTaskConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "CreateSchemeTaskConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSchemeTaskConfigResponse creates a response to parse from CreateSchemeTaskConfig response
func CreateCreateSchemeTaskConfigResponse() (response *CreateSchemeTaskConfigResponse) {
	response = &CreateSchemeTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
