package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTrafficControlTask invokes the pairecservice.GetTrafficControlTask API synchronously
func (client *Client) GetTrafficControlTask(request *GetTrafficControlTaskRequest) (response *GetTrafficControlTaskResponse, err error) {
	response = CreateGetTrafficControlTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetTrafficControlTaskWithChan invokes the pairecservice.GetTrafficControlTask API asynchronously
func (client *Client) GetTrafficControlTaskWithChan(request *GetTrafficControlTaskRequest) (<-chan *GetTrafficControlTaskResponse, <-chan error) {
	responseChan := make(chan *GetTrafficControlTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTrafficControlTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTrafficControlTaskWithCallback invokes the pairecservice.GetTrafficControlTask API asynchronously
func (client *Client) GetTrafficControlTaskWithCallback(request *GetTrafficControlTaskRequest, callback func(response *GetTrafficControlTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTrafficControlTaskResponse
		var err error
		defer close(result)
		response, err = client.GetTrafficControlTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTrafficControlTaskRequest is the request struct for api GetTrafficControlTask
type GetTrafficControlTaskRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Version              string `position:"Query" name:"Version"`
	ControlTargetFilter  string `position:"Query" name:"ControlTargetFilter"`
	Environment          string `position:"Query" name:"Environment"`
	InstanceId           string `position:"Query" name:"InstanceId"`
}

// GetTrafficControlTaskResponse is the response struct for api GetTrafficControlTask
type GetTrafficControlTaskResponse struct {
	*responses.BaseResponse
	RequestId                      string                      `json:"RequestId" xml:"RequestId"`
	TrafficControlTaskId           string                      `json:"TrafficControlTaskId" xml:"TrafficControlTaskId"`
	Name                           string                      `json:"Name" xml:"Name"`
	Description                    string                      `json:"Description" xml:"Description"`
	SceneId                        string                      `json:"SceneId" xml:"SceneId"`
	SceneName                      string                      `json:"SceneName" xml:"SceneName"`
	ProductStatus                  string                      `json:"ProductStatus" xml:"ProductStatus"`
	PrepubStatus                   string                      `json:"PrepubStatus" xml:"PrepubStatus"`
	ExecutionTime                  string                      `json:"ExecutionTime" xml:"ExecutionTime"`
	StartTime                      string                      `json:"StartTime" xml:"StartTime"`
	EndTime                        string                      `json:"EndTime" xml:"EndTime"`
	BehaviorTableMetaId            string                      `json:"BehaviorTableMetaId" xml:"BehaviorTableMetaId"`
	UserTableMetaId                string                      `json:"UserTableMetaId" xml:"UserTableMetaId"`
	ItemTableMetaId                string                      `json:"ItemTableMetaId" xml:"ItemTableMetaId"`
	UserConditionType              string                      `json:"UserConditionType" xml:"UserConditionType"`
	UserConditionArray             string                      `json:"UserConditionArray" xml:"UserConditionArray"`
	UserConditionExpress           string                      `json:"UserConditionExpress" xml:"UserConditionExpress"`
	StatisBehaviorConditionType    string                      `json:"StatisBehaviorConditionType" xml:"StatisBehaviorConditionType"`
	StatisBehaviorConditionArray   string                      `json:"StatisBehaviorConditionArray" xml:"StatisBehaviorConditionArray"`
	StatisBehaviorConditionExpress string                      `json:"StatisBehaviorConditionExpress" xml:"StatisBehaviorConditionExpress"`
	ControlType                    string                      `json:"ControlType" xml:"ControlType"`
	ControlGranularity             string                      `json:"ControlGranularity" xml:"ControlGranularity"`
	ControlLogic                   string                      `json:"ControlLogic" xml:"ControlLogic"`
	ItemConditionType              string                      `json:"ItemConditionType" xml:"ItemConditionType"`
	ItemConditionArray             string                      `json:"ItemConditionArray" xml:"ItemConditionArray"`
	ItemConditionExpress           string                      `json:"ItemConditionExpress" xml:"ItemConditionExpress"`
	GmtCreateTime                  string                      `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime                string                      `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	EverPublished                  bool                        `json:"EverPublished" xml:"EverPublished"`
	TrafficControlTargets          []TrafficControlTargetsItem `json:"TrafficControlTargets" xml:"TrafficControlTargets"`
}

// CreateGetTrafficControlTaskRequest creates a request to invoke GetTrafficControlTask API
func CreateGetTrafficControlTaskRequest() (request *GetTrafficControlTaskRequest) {
	request = &GetTrafficControlTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetTrafficControlTask", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTrafficControlTaskResponse creates a response to parse from GetTrafficControlTask response
func CreateGetTrafficControlTaskResponse() (response *GetTrafficControlTaskResponse) {
	response = &GetTrafficControlTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
