package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAfterAnswerDelayPlayback invokes the outboundbot.GetAfterAnswerDelayPlayback API synchronously
func (client *Client) GetAfterAnswerDelayPlayback(request *GetAfterAnswerDelayPlaybackRequest) (response *GetAfterAnswerDelayPlaybackResponse, err error) {
	response = CreateGetAfterAnswerDelayPlaybackResponse()
	err = client.DoAction(request, response)
	return
}

// GetAfterAnswerDelayPlaybackWithChan invokes the outboundbot.GetAfterAnswerDelayPlayback API asynchronously
func (client *Client) GetAfterAnswerDelayPlaybackWithChan(request *GetAfterAnswerDelayPlaybackRequest) (<-chan *GetAfterAnswerDelayPlaybackResponse, <-chan error) {
	responseChan := make(chan *GetAfterAnswerDelayPlaybackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAfterAnswerDelayPlayback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAfterAnswerDelayPlaybackWithCallback invokes the outboundbot.GetAfterAnswerDelayPlayback API asynchronously
func (client *Client) GetAfterAnswerDelayPlaybackWithCallback(request *GetAfterAnswerDelayPlaybackRequest, callback func(response *GetAfterAnswerDelayPlaybackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAfterAnswerDelayPlaybackResponse
		var err error
		defer close(result)
		response, err = client.GetAfterAnswerDelayPlayback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAfterAnswerDelayPlaybackRequest is the request struct for api GetAfterAnswerDelayPlayback
type GetAfterAnswerDelayPlaybackRequest struct {
	*requests.RpcRequest
	StrategyLevel requests.Integer `position:"Query" name:"StrategyLevel"`
	EntryId       string           `position:"Query" name:"EntryId"`
}

// GetAfterAnswerDelayPlaybackResponse is the response struct for api GetAfterAnswerDelayPlayback
type GetAfterAnswerDelayPlaybackResponse struct {
	*responses.BaseResponse
	HttpStatusCode           int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId                string `json:"RequestId" xml:"RequestId"`
	Success                  bool   `json:"Success" xml:"Success"`
	Code                     string `json:"Code" xml:"Code"`
	Message                  string `json:"Message" xml:"Message"`
	AfterAnswerDelayPlayback int    `json:"AfterAnswerDelayPlayback" xml:"AfterAnswerDelayPlayback"`
}

// CreateGetAfterAnswerDelayPlaybackRequest creates a request to invoke GetAfterAnswerDelayPlayback API
func CreateGetAfterAnswerDelayPlaybackRequest() (request *GetAfterAnswerDelayPlaybackRequest) {
	request = &GetAfterAnswerDelayPlaybackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "GetAfterAnswerDelayPlayback", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAfterAnswerDelayPlaybackResponse creates a response to parse from GetAfterAnswerDelayPlayback response
func CreateGetAfterAnswerDelayPlaybackResponse() (response *GetAfterAnswerDelayPlaybackResponse) {
	response = &GetAfterAnswerDelayPlaybackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
