package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppGroups invokes the opensearch.ListAppGroups API synchronously
func (client *Client) ListAppGroups(request *ListAppGroupsRequest) (response *ListAppGroupsResponse, err error) {
	response = CreateListAppGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppGroupsWithChan invokes the opensearch.ListAppGroups API asynchronously
func (client *Client) ListAppGroupsWithChan(request *ListAppGroupsRequest) (<-chan *ListAppGroupsResponse, <-chan error) {
	responseChan := make(chan *ListAppGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppGroupsWithCallback invokes the opensearch.ListAppGroups API asynchronously
func (client *Client) ListAppGroupsWithCallback(request *ListAppGroupsRequest, callback func(response *ListAppGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListAppGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppGroupsRequest is the request struct for api ListAppGroups
type ListAppGroupsRequest struct {
	*requests.RoaRequest
	ResourceGroupId string           `position:"Query" name:"resourceGroupId"`
	InstanceId      string           `position:"Query" name:"instanceId"`
	PageSize        requests.Integer `position:"Query" name:"pageSize"`
	Name            string           `position:"Query" name:"name"`
	SortBy          requests.Integer `position:"Query" name:"sortBy"`
	Type            string           `position:"Query" name:"type"`
	PageNumber      requests.Integer `position:"Query" name:"pageNumber"`
}

// ListAppGroupsResponse is the response struct for api ListAppGroups
type ListAppGroupsResponse struct {
	*responses.BaseResponse
	TotalCount int                         `json:"totalCount" xml:"totalCount"`
	RequestId  string                      `json:"requestId" xml:"requestId"`
	Result     []ResultItemInListAppGroups `json:"result" xml:"result"`
}

// CreateListAppGroupsRequest creates a request to invoke ListAppGroups API
func CreateListAppGroupsRequest() (request *ListAppGroupsRequest) {
	request = &ListAppGroupsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListAppGroups", "/v4/openapi/app-groups", "", "")
	request.Method = requests.GET
	return
}

// CreateListAppGroupsResponse creates a response to parse from ListAppGroups response
func CreateListAppGroupsResponse() (response *ListAppGroupsResponse) {
	response = &ListAppGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
