package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecommendIndex invokes the oceanbasepro.DescribeRecommendIndex API synchronously
func (client *Client) DescribeRecommendIndex(request *DescribeRecommendIndexRequest) (response *DescribeRecommendIndexResponse, err error) {
	response = CreateDescribeRecommendIndexResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecommendIndexWithChan invokes the oceanbasepro.DescribeRecommendIndex API asynchronously
func (client *Client) DescribeRecommendIndexWithChan(request *DescribeRecommendIndexRequest) (<-chan *DescribeRecommendIndexResponse, <-chan error) {
	responseChan := make(chan *DescribeRecommendIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecommendIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecommendIndexWithCallback invokes the oceanbasepro.DescribeRecommendIndex API asynchronously
func (client *Client) DescribeRecommendIndexWithCallback(request *DescribeRecommendIndexRequest, callback func(response *DescribeRecommendIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecommendIndexResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecommendIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecommendIndexRequest is the request struct for api DescribeRecommendIndex
type DescribeRecommendIndexRequest struct {
	*requests.RpcRequest
	SQLId      string `position:"Body" name:"SQLId"`
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeRecommendIndexResponse is the response struct for api DescribeRecommendIndex
type DescribeRecommendIndexResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	RecommendIndex RecommendIndex `json:"RecommendIndex" xml:"RecommendIndex"`
}

// CreateDescribeRecommendIndexRequest creates a request to invoke DescribeRecommendIndex API
func CreateDescribeRecommendIndexRequest() (request *DescribeRecommendIndexRequest) {
	request = &DescribeRecommendIndexRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeRecommendIndex", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRecommendIndexResponse creates a response to parse from DescribeRecommendIndex response
func CreateDescribeRecommendIndexResponse() (response *DescribeRecommendIndexResponse) {
	response = &DescribeRecommendIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
