package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCustomEntity invokes the mts.CreateCustomEntity API synchronously
func (client *Client) CreateCustomEntity(request *CreateCustomEntityRequest) (response *CreateCustomEntityResponse, err error) {
	response = CreateCreateCustomEntityResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCustomEntityWithChan invokes the mts.CreateCustomEntity API asynchronously
func (client *Client) CreateCustomEntityWithChan(request *CreateCustomEntityRequest) (<-chan *CreateCustomEntityResponse, <-chan error) {
	responseChan := make(chan *CreateCustomEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCustomEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCustomEntityWithCallback invokes the mts.CreateCustomEntity API asynchronously
func (client *Client) CreateCustomEntityWithCallback(request *CreateCustomEntityRequest, callback func(response *CreateCustomEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCustomEntityResponse
		var err error
		defer close(result)
		response, err = client.CreateCustomEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCustomEntityRequest is the request struct for api CreateCustomEntity
type CreateCustomEntityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Algorithm            string           `position:"Query" name:"Algorithm"`
	CustomGroupId        string           `position:"Query" name:"CustomGroupId"`
	CustomEntityName     string           `position:"Query" name:"CustomEntityName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CustomEntityInfo     string           `position:"Query" name:"CustomEntityInfo"`
}

// CreateCustomEntityResponse is the response struct for api CreateCustomEntity
type CreateCustomEntityResponse struct {
	*responses.BaseResponse
	CustomEntityId string `json:"CustomEntityId" xml:"CustomEntityId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCustomEntityRequest creates a request to invoke CreateCustomEntity API
func CreateCreateCustomEntityRequest() (request *CreateCustomEntityRequest) {
	request = &CreateCustomEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "CreateCustomEntity", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCustomEntityResponse creates a response to parse from CreateCustomEntity response
func CreateCreateCustomEntityResponse() (response *CreateCustomEntityResponse) {
	response = &CreateCustomEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
