package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNacosGrayConfig invokes the mse.UpdateNacosGrayConfig API synchronously
func (client *Client) UpdateNacosGrayConfig(request *UpdateNacosGrayConfigRequest) (response *UpdateNacosGrayConfigResponse, err error) {
	response = CreateUpdateNacosGrayConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNacosGrayConfigWithChan invokes the mse.UpdateNacosGrayConfig API asynchronously
func (client *Client) UpdateNacosGrayConfigWithChan(request *UpdateNacosGrayConfigRequest) (<-chan *UpdateNacosGrayConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateNacosGrayConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNacosGrayConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNacosGrayConfigWithCallback invokes the mse.UpdateNacosGrayConfig API asynchronously
func (client *Client) UpdateNacosGrayConfigWithCallback(request *UpdateNacosGrayConfigRequest, callback func(response *UpdateNacosGrayConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNacosGrayConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateNacosGrayConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNacosGrayConfigRequest is the request struct for api UpdateNacosGrayConfig
type UpdateNacosGrayConfigRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	AppName        string           `position:"Query" name:"AppName"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	GrayType       string           `position:"Query" name:"GrayType"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	Group          string           `position:"Query" name:"Group"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	Content        string           `position:"Query" name:"Content"`
	GrayRule       string           `position:"Query" name:"GrayRule"`
	StopGray       requests.Boolean `position:"Query" name:"StopGray"`
	DataId         string           `position:"Query" name:"DataId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// UpdateNacosGrayConfigResponse is the response struct for api UpdateNacosGrayConfig
type UpdateNacosGrayConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateUpdateNacosGrayConfigRequest creates a request to invoke UpdateNacosGrayConfig API
func CreateUpdateNacosGrayConfigRequest() (request *UpdateNacosGrayConfigRequest) {
	request = &UpdateNacosGrayConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateNacosGrayConfig", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNacosGrayConfigResponse creates a response to parse from UpdateNacosGrayConfig response
func CreateUpdateNacosGrayConfigResponse() (response *UpdateNacosGrayConfigResponse) {
	response = &UpdateNacosGrayConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
