package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PullServices invokes the mse.PullServices API synchronously
func (client *Client) PullServices(request *PullServicesRequest) (response *PullServicesResponse, err error) {
	response = CreatePullServicesResponse()
	err = client.DoAction(request, response)
	return
}

// PullServicesWithChan invokes the mse.PullServices API asynchronously
func (client *Client) PullServicesWithChan(request *PullServicesRequest) (<-chan *PullServicesResponse, <-chan error) {
	responseChan := make(chan *PullServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PullServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PullServicesWithCallback invokes the mse.PullServices API asynchronously
func (client *Client) PullServicesWithCallback(request *PullServicesRequest, callback func(response *PullServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PullServicesResponse
		var err error
		defer close(result)
		response, err = client.PullServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PullServicesRequest is the request struct for api PullServices
type PullServicesRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	SourceType      string `position:"Query" name:"SourceType"`
	Namespace       string `position:"Query" name:"Namespace"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// PullServicesResponse is the response struct for api PullServices
type PullServicesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string         `json:"Message" xml:"Message"`
	Code           int            `json:"Code" xml:"Code"`
	Success        bool           `json:"Success" xml:"Success"`
	Data           []PullServices `json:"Data" xml:"Data"`
}

// CreatePullServicesRequest creates a request to invoke PullServices API
func CreatePullServicesRequest() (request *PullServicesRequest) {
	request = &PullServicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "PullServices", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePullServicesResponse creates a response to parse from PullServices response
func CreatePullServicesResponse() (response *PullServicesResponse) {
	response = &PullServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
