package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApplicationInstanceList invokes the mse.GetApplicationInstanceList API synchronously
func (client *Client) GetApplicationInstanceList(request *GetApplicationInstanceListRequest) (response *GetApplicationInstanceListResponse, err error) {
	response = CreateGetApplicationInstanceListResponse()
	err = client.DoAction(request, response)
	return
}

// GetApplicationInstanceListWithChan invokes the mse.GetApplicationInstanceList API asynchronously
func (client *Client) GetApplicationInstanceListWithChan(request *GetApplicationInstanceListRequest) (<-chan *GetApplicationInstanceListResponse, <-chan error) {
	responseChan := make(chan *GetApplicationInstanceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApplicationInstanceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApplicationInstanceListWithCallback invokes the mse.GetApplicationInstanceList API asynchronously
func (client *Client) GetApplicationInstanceListWithCallback(request *GetApplicationInstanceListRequest, callback func(response *GetApplicationInstanceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApplicationInstanceListResponse
		var err error
		defer close(result)
		response, err = client.GetApplicationInstanceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApplicationInstanceListRequest is the request struct for api GetApplicationInstanceList
type GetApplicationInstanceListRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	AppName        string           `position:"Query" name:"AppName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Tag            string           `position:"Query" name:"Tag"`
	AppId          string           `position:"Query" name:"AppId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	Region         string           `position:"Query" name:"Region"`
}

// GetApplicationInstanceListResponse is the response struct for api GetApplicationInstanceList
type GetApplicationInstanceListResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	Message        string                           `json:"Message" xml:"Message"`
	PageSize       int                              `json:"PageSize" xml:"PageSize"`
	PageNumber     int                              `json:"PageNumber" xml:"PageNumber"`
	TotalSize      int                              `json:"TotalSize" xml:"TotalSize"`
	Code           int                              `json:"Code" xml:"Code"`
	Success        bool                             `json:"Success" xml:"Success"`
	Data           DataInGetApplicationInstanceList `json:"Data" xml:"Data"`
}

// CreateGetApplicationInstanceListRequest creates a request to invoke GetApplicationInstanceList API
func CreateGetApplicationInstanceListRequest() (request *GetApplicationInstanceListRequest) {
	request = &GetApplicationInstanceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetApplicationInstanceList", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetApplicationInstanceListResponse creates a response to parse from GetApplicationInstanceList response
func CreateGetApplicationInstanceListResponse() (response *GetApplicationInstanceListResponse) {
	response = &GetApplicationInstanceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
