package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMcubeUpgradePackageInfo invokes the mpaas.GetMcubeUpgradePackageInfo API synchronously
func (client *Client) GetMcubeUpgradePackageInfo(request *GetMcubeUpgradePackageInfoRequest) (response *GetMcubeUpgradePackageInfoResponse, err error) {
	response = CreateGetMcubeUpgradePackageInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetMcubeUpgradePackageInfoWithChan invokes the mpaas.GetMcubeUpgradePackageInfo API asynchronously
func (client *Client) GetMcubeUpgradePackageInfoWithChan(request *GetMcubeUpgradePackageInfoRequest) (<-chan *GetMcubeUpgradePackageInfoResponse, <-chan error) {
	responseChan := make(chan *GetMcubeUpgradePackageInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMcubeUpgradePackageInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMcubeUpgradePackageInfoWithCallback invokes the mpaas.GetMcubeUpgradePackageInfo API asynchronously
func (client *Client) GetMcubeUpgradePackageInfoWithCallback(request *GetMcubeUpgradePackageInfoRequest, callback func(response *GetMcubeUpgradePackageInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMcubeUpgradePackageInfoResponse
		var err error
		defer close(result)
		response, err = client.GetMcubeUpgradePackageInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMcubeUpgradePackageInfoRequest is the request struct for api GetMcubeUpgradePackageInfo
type GetMcubeUpgradePackageInfoRequest struct {
	*requests.RpcRequest
	PackageId   requests.Integer `position:"Body" name:"PackageId"`
	TenantId    string           `position:"Body" name:"TenantId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetMcubeUpgradePackageInfoResponse is the response struct for api GetMcubeUpgradePackageInfo
type GetMcubeUpgradePackageInfoResponse struct {
	*responses.BaseResponse
	ResultMessage    string           `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode       string           `json:"ResultCode" xml:"ResultCode"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	GetPackageResult GetPackageResult `json:"GetPackageResult" xml:"GetPackageResult"`
}

// CreateGetMcubeUpgradePackageInfoRequest creates a request to invoke GetMcubeUpgradePackageInfo API
func CreateGetMcubeUpgradePackageInfoRequest() (request *GetMcubeUpgradePackageInfoRequest) {
	request = &GetMcubeUpgradePackageInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetMcubeUpgradePackageInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMcubeUpgradePackageInfoResponse creates a response to parse from GetMcubeUpgradePackageInfo response
func CreateGetMcubeUpgradePackageInfoResponse() (response *GetMcubeUpgradePackageInfoResponse) {
	response = &GetMcubeUpgradePackageInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
