package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllBizChain invokes the lto.ListAllBizChain API synchronously
func (client *Client) ListAllBizChain(request *ListAllBizChainRequest) (response *ListAllBizChainResponse, err error) {
	response = CreateListAllBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllBizChainWithChan invokes the lto.ListAllBizChain API asynchronously
func (client *Client) ListAllBizChainWithChan(request *ListAllBizChainRequest) (<-chan *ListAllBizChainResponse, <-chan error) {
	responseChan := make(chan *ListAllBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllBizChainWithCallback invokes the lto.ListAllBizChain API asynchronously
func (client *Client) ListAllBizChainWithCallback(request *ListAllBizChainRequest, callback func(response *ListAllBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllBizChainResponse
		var err error
		defer close(result)
		response, err = client.ListAllBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllBizChainRequest is the request struct for api ListAllBizChain
type ListAllBizChainRequest struct {
	*requests.RpcRequest
}

// ListAllBizChainResponse is the response struct for api ListAllBizChain
type ListAllBizChainResponse struct {
	*responses.BaseResponse
	Code           string         `json:"Code" xml:"Code"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Data           []BizChainInfo `json:"Data" xml:"Data"`
}

// CreateListAllBizChainRequest creates a request to invoke ListAllBizChain API
func CreateListAllBizChainRequest() (request *ListAllBizChainRequest) {
	request = &ListAllBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListAllBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllBizChainResponse creates a response to parse from ListAllBizChain response
func CreateListAllBizChainResponse() (response *ListAllBizChainResponse) {
	response = &ListAllBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
