package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMemberBizChainStatInfo invokes the lto.DescribeMemberBizChainStatInfo API synchronously
func (client *Client) DescribeMemberBizChainStatInfo(request *DescribeMemberBizChainStatInfoRequest) (response *DescribeMemberBizChainStatInfoResponse, err error) {
	response = CreateDescribeMemberBizChainStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMemberBizChainStatInfoWithChan invokes the lto.DescribeMemberBizChainStatInfo API asynchronously
func (client *Client) DescribeMemberBizChainStatInfoWithChan(request *DescribeMemberBizChainStatInfoRequest) (<-chan *DescribeMemberBizChainStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeMemberBizChainStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMemberBizChainStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMemberBizChainStatInfoWithCallback invokes the lto.DescribeMemberBizChainStatInfo API asynchronously
func (client *Client) DescribeMemberBizChainStatInfoWithCallback(request *DescribeMemberBizChainStatInfoRequest, callback func(response *DescribeMemberBizChainStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMemberBizChainStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeMemberBizChainStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMemberBizChainStatInfoRequest is the request struct for api DescribeMemberBizChainStatInfo
type DescribeMemberBizChainStatInfoRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// DescribeMemberBizChainStatInfoResponse is the response struct for api DescribeMemberBizChainStatInfo
type DescribeMemberBizChainStatInfoResponse struct {
	*responses.BaseResponse
	Code           string                   `json:"Code" xml:"Code"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                   `json:"Message" xml:"Message"`
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Success        bool                     `json:"Success" xml:"Success"`
	Data           []MemberBizChainStatInfo `json:"Data" xml:"Data"`
}

// CreateDescribeMemberBizChainStatInfoRequest creates a request to invoke DescribeMemberBizChainStatInfo API
func CreateDescribeMemberBizChainStatInfoRequest() (request *DescribeMemberBizChainStatInfoRequest) {
	request = &DescribeMemberBizChainStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeMemberBizChainStatInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMemberBizChainStatInfoResponse creates a response to parse from DescribeMemberBizChainStatInfo response
func CreateDescribeMemberBizChainStatInfoResponse() (response *DescribeMemberBizChainStatInfoResponse) {
	response = &DescribeMemberBizChainStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
