package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMemberCapacityInfo invokes the ltl.DescribeMemberCapacityInfo API synchronously
func (client *Client) DescribeMemberCapacityInfo(request *DescribeMemberCapacityInfoRequest) (response *DescribeMemberCapacityInfoResponse, err error) {
	response = CreateDescribeMemberCapacityInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMemberCapacityInfoWithChan invokes the ltl.DescribeMemberCapacityInfo API asynchronously
func (client *Client) DescribeMemberCapacityInfoWithChan(request *DescribeMemberCapacityInfoRequest) (<-chan *DescribeMemberCapacityInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeMemberCapacityInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMemberCapacityInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMemberCapacityInfoWithCallback invokes the ltl.DescribeMemberCapacityInfo API asynchronously
func (client *Client) DescribeMemberCapacityInfoWithCallback(request *DescribeMemberCapacityInfoRequest, callback func(response *DescribeMemberCapacityInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMemberCapacityInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeMemberCapacityInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMemberCapacityInfoRequest is the request struct for api DescribeMemberCapacityInfo
type DescribeMemberCapacityInfoRequest struct {
	*requests.RpcRequest
	ApiVersion string `position:"Query" name:"ApiVersion"`
	BizChainId string `position:"Query" name:"BizChainId"`
}

// DescribeMemberCapacityInfoResponse is the response struct for api DescribeMemberCapacityInfo
type DescribeMemberCapacityInfoResponse struct {
	*responses.BaseResponse
	Code      int                  `json:"Code" xml:"Code"`
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Success   bool                 `json:"Success" xml:"Success"`
	Data      []MemberCapacityInfo `json:"Data" xml:"Data"`
}

// CreateDescribeMemberCapacityInfoRequest creates a request to invoke DescribeMemberCapacityInfo API
func CreateDescribeMemberCapacityInfoRequest() (request *DescribeMemberCapacityInfoRequest) {
	request = &DescribeMemberCapacityInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "DescribeMemberCapacityInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMemberCapacityInfoResponse creates a response to parse from DescribeMemberCapacityInfo response
func CreateDescribeMemberCapacityInfoResponse() (response *DescribeMemberCapacityInfoResponse) {
	response = &DescribeMemberCapacityInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
