package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachData invokes the ltl.AttachData API synchronously
func (client *Client) AttachData(request *AttachDataRequest) (response *AttachDataResponse, err error) {
	response = CreateAttachDataResponse()
	err = client.DoAction(request, response)
	return
}

// AttachDataWithChan invokes the ltl.AttachData API asynchronously
func (client *Client) AttachDataWithChan(request *AttachDataRequest) (<-chan *AttachDataResponse, <-chan error) {
	responseChan := make(chan *AttachDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachDataWithCallback invokes the ltl.AttachData API asynchronously
func (client *Client) AttachDataWithCallback(request *AttachDataRequest, callback func(response *AttachDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachDataResponse
		var err error
		defer close(result)
		response, err = client.AttachData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachDataRequest is the request struct for api AttachData
type AttachDataRequest struct {
	*requests.RpcRequest
	BusinessId string `position:"Query" name:"BusinessId"`
	ApiVersion string `position:"Query" name:"ApiVersion"`
	ProductKey string `position:"Query" name:"ProductKey"`
	Value      string `position:"Query" name:"Value"`
	Key        string `position:"Query" name:"Key"`
}

// AttachDataResponse is the response struct for api AttachData
type AttachDataResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAttachDataRequest creates a request to invoke AttachData API
func CreateAttachDataRequest() (request *AttachDataRequest) {
	request = &AttachDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "AttachData", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachDataResponse creates a response to parse from AttachData response
func CreateAttachDataResponse() (response *AttachDataResponse) {
	response = &AttachDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
