package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceVodUrlByTime invokes the linkvisual.QueryDeviceVodUrlByTime API synchronously
func (client *Client) QueryDeviceVodUrlByTime(request *QueryDeviceVodUrlByTimeRequest) (response *QueryDeviceVodUrlByTimeResponse, err error) {
	response = CreateQueryDeviceVodUrlByTimeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceVodUrlByTimeWithChan invokes the linkvisual.QueryDeviceVodUrlByTime API asynchronously
func (client *Client) QueryDeviceVodUrlByTimeWithChan(request *QueryDeviceVodUrlByTimeRequest) (<-chan *QueryDeviceVodUrlByTimeResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceVodUrlByTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceVodUrlByTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceVodUrlByTimeWithCallback invokes the linkvisual.QueryDeviceVodUrlByTime API asynchronously
func (client *Client) QueryDeviceVodUrlByTimeWithCallback(request *QueryDeviceVodUrlByTimeRequest, callback func(response *QueryDeviceVodUrlByTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceVodUrlByTimeResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceVodUrlByTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceVodUrlByTimeRequest is the request struct for api QueryDeviceVodUrlByTime
type QueryDeviceVodUrlByTimeRequest struct {
	*requests.RpcRequest
	Scheme           string           `position:"Query" name:"Scheme"`
	PlayUnLimited    requests.Boolean `position:"Query" name:"PlayUnLimited"`
	EncryptType      requests.Integer `position:"Query" name:"EncryptType"`
	IotId            string           `position:"Query" name:"IotId"`
	IotInstanceId    string           `position:"Query" name:"IotInstanceId"`
	ShouldEncrypt    requests.Boolean `position:"Query" name:"ShouldEncrypt"`
	EnableStun       requests.Boolean `position:"Query" name:"EnableStun"`
	EndTime          requests.Integer `position:"Query" name:"EndTime"`
	BeginTime        requests.Integer `position:"Query" name:"BeginTime"`
	ProductKey       string           `position:"Query" name:"ProductKey"`
	SeekTime         requests.Integer `position:"Query" name:"SeekTime"`
	ApiProduct       string           `position:"Body" name:"ApiProduct"`
	ApiRevision      string           `position:"Body" name:"ApiRevision"`
	DeviceName       string           `position:"Query" name:"DeviceName"`
	UrlValidDuration requests.Integer `position:"Query" name:"UrlValidDuration"`
}

// QueryDeviceVodUrlByTimeResponse is the response struct for api QueryDeviceVodUrlByTime
type QueryDeviceVodUrlByTimeResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryDeviceVodUrlByTimeRequest creates a request to invoke QueryDeviceVodUrlByTime API
func CreateQueryDeviceVodUrlByTimeRequest() (request *QueryDeviceVodUrlByTimeRequest) {
	request = &QueryDeviceVodUrlByTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryDeviceVodUrlByTime", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceVodUrlByTimeResponse creates a response to parse from QueryDeviceVodUrlByTime response
func CreateQueryDeviceVodUrlByTimeResponse() (response *QueryDeviceVodUrlByTimeResponse) {
	response = &QueryDeviceVodUrlByTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
