package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSceneRule invokes the iot.CreateSceneRule API synchronously
func (client *Client) CreateSceneRule(request *CreateSceneRuleRequest) (response *CreateSceneRuleResponse, err error) {
	response = CreateCreateSceneRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSceneRuleWithChan invokes the iot.CreateSceneRule API asynchronously
func (client *Client) CreateSceneRuleWithChan(request *CreateSceneRuleRequest) (<-chan *CreateSceneRuleResponse, <-chan error) {
	responseChan := make(chan *CreateSceneRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSceneRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSceneRuleWithCallback invokes the iot.CreateSceneRule API asynchronously
func (client *Client) CreateSceneRuleWithCallback(request *CreateSceneRuleRequest, callback func(response *CreateSceneRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSceneRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateSceneRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSceneRuleRequest is the request struct for api CreateSceneRule
type CreateSceneRuleRequest struct {
	*requests.RpcRequest
	RuleName        string `position:"Query" name:"RuleName"`
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
	RuleDescription string `position:"Query" name:"RuleDescription"`
	RuleContent     string `position:"Query" name:"RuleContent"`
	ApiProduct      string `position:"Body" name:"ApiProduct"`
	ApiRevision     string `position:"Body" name:"ApiRevision"`
}

// CreateSceneRuleResponse is the response struct for api CreateSceneRule
type CreateSceneRuleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RuleId       string `json:"RuleId" xml:"RuleId"`
}

// CreateCreateSceneRuleRequest creates a request to invoke CreateSceneRule API
func CreateCreateSceneRuleRequest() (request *CreateSceneRuleRequest) {
	request = &CreateSceneRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateSceneRule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSceneRuleResponse creates a response to parse from CreateSceneRule response
func CreateCreateSceneRuleResponse() (response *CreateSceneRuleResponse) {
	response = &CreateSceneRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
