package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEdgeInstanceMessageRouting invokes the iot.CreateEdgeInstanceMessageRouting API synchronously
func (client *Client) CreateEdgeInstanceMessageRouting(request *CreateEdgeInstanceMessageRoutingRequest) (response *CreateEdgeInstanceMessageRoutingResponse, err error) {
	response = CreateCreateEdgeInstanceMessageRoutingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEdgeInstanceMessageRoutingWithChan invokes the iot.CreateEdgeInstanceMessageRouting API asynchronously
func (client *Client) CreateEdgeInstanceMessageRoutingWithChan(request *CreateEdgeInstanceMessageRoutingRequest) (<-chan *CreateEdgeInstanceMessageRoutingResponse, <-chan error) {
	responseChan := make(chan *CreateEdgeInstanceMessageRoutingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEdgeInstanceMessageRouting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEdgeInstanceMessageRoutingWithCallback invokes the iot.CreateEdgeInstanceMessageRouting API asynchronously
func (client *Client) CreateEdgeInstanceMessageRoutingWithCallback(request *CreateEdgeInstanceMessageRoutingRequest, callback func(response *CreateEdgeInstanceMessageRoutingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEdgeInstanceMessageRoutingResponse
		var err error
		defer close(result)
		response, err = client.CreateEdgeInstanceMessageRouting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEdgeInstanceMessageRoutingRequest is the request struct for api CreateEdgeInstanceMessageRouting
type CreateEdgeInstanceMessageRoutingRequest struct {
	*requests.RpcRequest
	SourceData      string           `position:"Query" name:"SourceData"`
	TargetType      string           `position:"Query" name:"TargetType"`
	IotInstanceId   string           `position:"Query" name:"IotInstanceId"`
	SourceType      string           `position:"Query" name:"SourceType"`
	TopicFilter     string           `position:"Query" name:"TopicFilter"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	TargetData      string           `position:"Query" name:"TargetData"`
	ApiProduct      string           `position:"Body" name:"ApiProduct"`
	Name            string           `position:"Query" name:"Name"`
	ApiRevision     string           `position:"Body" name:"ApiRevision"`
	TargetIotHubQos requests.Integer `position:"Query" name:"TargetIotHubQos"`
}

// CreateEdgeInstanceMessageRoutingResponse is the response struct for api CreateEdgeInstanceMessageRouting
type CreateEdgeInstanceMessageRoutingResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RouteId      int64  `json:"RouteId" xml:"RouteId"`
}

// CreateCreateEdgeInstanceMessageRoutingRequest creates a request to invoke CreateEdgeInstanceMessageRouting API
func CreateCreateEdgeInstanceMessageRoutingRequest() (request *CreateEdgeInstanceMessageRoutingRequest) {
	request = &CreateEdgeInstanceMessageRoutingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateEdgeInstanceMessageRouting", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEdgeInstanceMessageRoutingResponse creates a response to parse from CreateEdgeInstanceMessageRouting response
func CreateCreateEdgeInstanceMessageRoutingResponse() (response *CreateEdgeInstanceMessageRoutingResponse) {
	response = &CreateEdgeInstanceMessageRoutingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
