package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScreenLC invokes the imageprocess.ScreenLC API synchronously
func (client *Client) ScreenLC(request *ScreenLCRequest) (response *ScreenLCResponse, err error) {
	response = CreateScreenLCResponse()
	err = client.DoAction(request, response)
	return
}

// ScreenLCWithChan invokes the imageprocess.ScreenLC API asynchronously
func (client *Client) ScreenLCWithChan(request *ScreenLCRequest) (<-chan *ScreenLCResponse, <-chan error) {
	responseChan := make(chan *ScreenLCResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScreenLC(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScreenLCWithCallback invokes the imageprocess.ScreenLC API asynchronously
func (client *Client) ScreenLCWithCallback(request *ScreenLCRequest, callback func(response *ScreenLCResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScreenLCResponse
		var err error
		defer close(result)
		response, err = client.ScreenLC(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScreenLCRequest is the request struct for api ScreenLC
type ScreenLCRequest struct {
	*requests.RpcRequest
	DataSourceType string             `position:"Body" name:"DataSourceType"`
	OrgName        string             `position:"Body" name:"OrgName"`
	DataFormat     string             `position:"Body" name:"DataFormat"`
	URLList        *[]ScreenLCURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId          string             `position:"Body" name:"OrgId"`
	Async          requests.Boolean   `position:"Body" name:"Async"`
}

// ScreenLCURLList is a repeated param struct in ScreenLCRequest
type ScreenLCURLList struct {
	URL string `name:"URL"`
}

// ScreenLCResponse is the response struct for api ScreenLC
type ScreenLCResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateScreenLCRequest creates a request to invoke ScreenLC API
func CreateScreenLCRequest() (request *ScreenLCRequest) {
	request = &ScreenLCRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "ScreenLC", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScreenLCResponse creates a response to parse from ScreenLC response
func CreateScreenLCResponse() (response *ScreenLCResponse) {
	response = &ScreenLCResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
