package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpsertCollectionData invokes the gpdb.UpsertCollectionData API synchronously
func (client *Client) UpsertCollectionData(request *UpsertCollectionDataRequest) (response *UpsertCollectionDataResponse, err error) {
	response = CreateUpsertCollectionDataResponse()
	err = client.DoAction(request, response)
	return
}

// UpsertCollectionDataWithChan invokes the gpdb.UpsertCollectionData API asynchronously
func (client *Client) UpsertCollectionDataWithChan(request *UpsertCollectionDataRequest) (<-chan *UpsertCollectionDataResponse, <-chan error) {
	responseChan := make(chan *UpsertCollectionDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpsertCollectionData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpsertCollectionDataWithCallback invokes the gpdb.UpsertCollectionData API asynchronously
func (client *Client) UpsertCollectionDataWithCallback(request *UpsertCollectionDataRequest, callback func(response *UpsertCollectionDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpsertCollectionDataResponse
		var err error
		defer close(result)
		response, err = client.UpsertCollectionData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpsertCollectionDataRequest is the request struct for api UpsertCollectionData
type UpsertCollectionDataRequest struct {
	*requests.RpcRequest
	DBInstanceId      string                      `position:"Query" name:"DBInstanceId"`
	Collection        string                      `position:"Query" name:"Collection"`
	OwnerId           requests.Integer            `position:"Query" name:"OwnerId"`
	Rows              *[]UpsertCollectionDataRows `position:"Query" name:"Rows"  type:"Json"`
	NamespacePassword string                      `position:"Query" name:"NamespacePassword"`
	Namespace         string                      `position:"Query" name:"Namespace"`
}

// UpsertCollectionDataRows is a repeated param struct in UpsertCollectionDataRequest
type UpsertCollectionDataRows struct {
	Metadata map[string]string `name:"Metadata" type:"Map"`
	Vector   *[]string         `name:"Vector" type:"Repeated"`
	Id       string            `name:"Id"`
}

// UpsertCollectionDataResponse is the response struct for api UpsertCollectionData
type UpsertCollectionDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateUpsertCollectionDataRequest creates a request to invoke UpsertCollectionData API
func CreateUpsertCollectionDataRequest() (request *UpsertCollectionDataRequest) {
	request = &UpsertCollectionDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "UpsertCollectionData", "", "")
	request.Method = requests.POST
	return
}

// CreateUpsertCollectionDataResponse creates a response to parse from UpsertCollectionData response
func CreateUpsertCollectionDataResponse() (response *UpsertCollectionDataResponse) {
	response = &UpsertCollectionDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
