package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsSaleControlStock invokes the ens.DescribeEnsSaleControlStock API synchronously
func (client *Client) DescribeEnsSaleControlStock(request *DescribeEnsSaleControlStockRequest) (response *DescribeEnsSaleControlStockResponse, err error) {
	response = CreateDescribeEnsSaleControlStockResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsSaleControlStockWithChan invokes the ens.DescribeEnsSaleControlStock API asynchronously
func (client *Client) DescribeEnsSaleControlStockWithChan(request *DescribeEnsSaleControlStockRequest) (<-chan *DescribeEnsSaleControlStockResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsSaleControlStockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsSaleControlStock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsSaleControlStockWithCallback invokes the ens.DescribeEnsSaleControlStock API asynchronously
func (client *Client) DescribeEnsSaleControlStockWithCallback(request *DescribeEnsSaleControlStockRequest, callback func(response *DescribeEnsSaleControlStockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsSaleControlStockResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsSaleControlStock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsSaleControlStockRequest is the request struct for api DescribeEnsSaleControlStock
type DescribeEnsSaleControlStockRequest struct {
	*requests.RpcRequest
	CustomAccount string `position:"Query" name:"CustomAccount"`
	CommodityCode string `position:"Query" name:"CommodityCode"`
	ModuleCode    string `position:"Query" name:"ModuleCode"`
	AliUidAccount string `position:"Query" name:"AliUidAccount"`
	OrderType     string `position:"Query" name:"OrderType"`
}

// DescribeEnsSaleControlStockResponse is the response struct for api DescribeEnsSaleControlStock
type DescribeEnsSaleControlStockResponse struct {
	*responses.BaseResponse
	RequestId   string                                         `json:"RequestId" xml:"RequestId"`
	SaleControl []SaleControlItemInDescribeEnsSaleControlStock `json:"SaleControl" xml:"SaleControl"`
}

// CreateDescribeEnsSaleControlStockRequest creates a request to invoke DescribeEnsSaleControlStock API
func CreateDescribeEnsSaleControlStockRequest() (request *DescribeEnsSaleControlStockRequest) {
	request = &DescribeEnsSaleControlStockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsSaleControlStock", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsSaleControlStockResponse creates a response to parse from DescribeEnsSaleControlStock response
func CreateDescribeEnsSaleControlStockResponse() (response *DescribeEnsSaleControlStockResponse) {
	response = &DescribeEnsSaleControlStockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
