package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNetworkInterfaces invokes the ens.DeleteNetworkInterfaces API synchronously
func (client *Client) DeleteNetworkInterfaces(request *DeleteNetworkInterfacesRequest) (response *DeleteNetworkInterfacesResponse, err error) {
	response = CreateDeleteNetworkInterfacesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNetworkInterfacesWithChan invokes the ens.DeleteNetworkInterfaces API asynchronously
func (client *Client) DeleteNetworkInterfacesWithChan(request *DeleteNetworkInterfacesRequest) (<-chan *DeleteNetworkInterfacesResponse, <-chan error) {
	responseChan := make(chan *DeleteNetworkInterfacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNetworkInterfaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNetworkInterfacesWithCallback invokes the ens.DeleteNetworkInterfaces API asynchronously
func (client *Client) DeleteNetworkInterfacesWithCallback(request *DeleteNetworkInterfacesRequest, callback func(response *DeleteNetworkInterfacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNetworkInterfacesResponse
		var err error
		defer close(result)
		response, err = client.DeleteNetworkInterfaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNetworkInterfacesRequest is the request struct for api DeleteNetworkInterfaces
type DeleteNetworkInterfacesRequest struct {
	*requests.RpcRequest
	NetworkInterfaceIds *[]string `position:"Query" name:"NetworkInterfaceIds"  type:"Json"`
}

// DeleteNetworkInterfacesResponse is the response struct for api DeleteNetworkInterfaces
type DeleteNetworkInterfacesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNetworkInterfacesRequest creates a request to invoke DeleteNetworkInterfaces API
func CreateDeleteNetworkInterfacesRequest() (request *DeleteNetworkInterfacesRequest) {
	request = &DeleteNetworkInterfacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteNetworkInterfaces", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNetworkInterfacesResponse creates a response to parse from DeleteNetworkInterfaces response
func CreateDeleteNetworkInterfacesResponse() (response *DeleteNetworkInterfacesResponse) {
	response = &DeleteNetworkInterfacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
