package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkAclEntry invokes the ens.CreateNetworkAclEntry API synchronously
func (client *Client) CreateNetworkAclEntry(request *CreateNetworkAclEntryRequest) (response *CreateNetworkAclEntryResponse, err error) {
	response = CreateCreateNetworkAclEntryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkAclEntryWithChan invokes the ens.CreateNetworkAclEntry API asynchronously
func (client *Client) CreateNetworkAclEntryWithChan(request *CreateNetworkAclEntryRequest) (<-chan *CreateNetworkAclEntryResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkAclEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkAclEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkAclEntryWithCallback invokes the ens.CreateNetworkAclEntry API asynchronously
func (client *Client) CreateNetworkAclEntryWithCallback(request *CreateNetworkAclEntryRequest, callback func(response *CreateNetworkAclEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkAclEntryResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkAclEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkAclEntryRequest is the request struct for api CreateNetworkAclEntry
type CreateNetworkAclEntryRequest struct {
	*requests.RpcRequest
	NetworkAclEntryName string           `position:"Query" name:"NetworkAclEntryName"`
	Protocol            string           `position:"Query" name:"Protocol"`
	PortRange           string           `position:"Query" name:"PortRange"`
	Priority            requests.Integer `position:"Query" name:"Priority"`
	Description         string           `position:"Query" name:"Description"`
	NetworkAclId        string           `position:"Query" name:"NetworkAclId"`
	Direction           string           `position:"Query" name:"Direction"`
	Policy              string           `position:"Query" name:"Policy"`
	CidrBlock           string           `position:"Query" name:"CidrBlock"`
}

// CreateNetworkAclEntryResponse is the response struct for api CreateNetworkAclEntry
type CreateNetworkAclEntryResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	NetworkAclEntryId string `json:"NetworkAclEntryId" xml:"NetworkAclEntryId"`
}

// CreateCreateNetworkAclEntryRequest creates a request to invoke CreateNetworkAclEntry API
func CreateCreateNetworkAclEntryRequest() (request *CreateNetworkAclEntryRequest) {
	request = &CreateNetworkAclEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateNetworkAclEntry", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNetworkAclEntryResponse creates a response to parse from CreateNetworkAclEntry response
func CreateCreateNetworkAclEntryResponse() (response *CreateNetworkAclEntryResponse) {
	response = &CreateNetworkAclEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
