package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSnatIpForSnatEntry invokes the ens.AddSnatIpForSnatEntry API synchronously
func (client *Client) AddSnatIpForSnatEntry(request *AddSnatIpForSnatEntryRequest) (response *AddSnatIpForSnatEntryResponse, err error) {
	response = CreateAddSnatIpForSnatEntryResponse()
	err = client.DoAction(request, response)
	return
}

// AddSnatIpForSnatEntryWithChan invokes the ens.AddSnatIpForSnatEntry API asynchronously
func (client *Client) AddSnatIpForSnatEntryWithChan(request *AddSnatIpForSnatEntryRequest) (<-chan *AddSnatIpForSnatEntryResponse, <-chan error) {
	responseChan := make(chan *AddSnatIpForSnatEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSnatIpForSnatEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSnatIpForSnatEntryWithCallback invokes the ens.AddSnatIpForSnatEntry API asynchronously
func (client *Client) AddSnatIpForSnatEntryWithCallback(request *AddSnatIpForSnatEntryRequest, callback func(response *AddSnatIpForSnatEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSnatIpForSnatEntryResponse
		var err error
		defer close(result)
		response, err = client.AddSnatIpForSnatEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSnatIpForSnatEntryRequest is the request struct for api AddSnatIpForSnatEntry
type AddSnatIpForSnatEntryRequest struct {
	*requests.RpcRequest
	SnatIp      string `position:"Query" name:"SnatIp"`
	SnatEntryId string `position:"Query" name:"SnatEntryId"`
}

// AddSnatIpForSnatEntryResponse is the response struct for api AddSnatIpForSnatEntry
type AddSnatIpForSnatEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddSnatIpForSnatEntryRequest creates a request to invoke AddSnatIpForSnatEntry API
func CreateAddSnatIpForSnatEntryRequest() (request *AddSnatIpForSnatEntryRequest) {
	request = &AddSnatIpForSnatEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "AddSnatIpForSnatEntry", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddSnatIpForSnatEntryResponse creates a response to parse from AddSnatIpForSnatEntry response
func CreateAddSnatIpForSnatEntryResponse() (response *AddSnatIpForSnatEntryResponse) {
	response = &AddSnatIpForSnatEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
