package ehpcinstant

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJobMetricData invokes the ehpcinstant.DescribeJobMetricData API synchronously
func (client *Client) DescribeJobMetricData(request *DescribeJobMetricDataRequest) (response *DescribeJobMetricDataResponse, err error) {
	response = CreateDescribeJobMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobMetricDataWithChan invokes the ehpcinstant.DescribeJobMetricData API asynchronously
func (client *Client) DescribeJobMetricDataWithChan(request *DescribeJobMetricDataRequest) (<-chan *DescribeJobMetricDataResponse, <-chan error) {
	responseChan := make(chan *DescribeJobMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJobMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobMetricDataWithCallback invokes the ehpcinstant.DescribeJobMetricData API asynchronously
func (client *Client) DescribeJobMetricDataWithCallback(request *DescribeJobMetricDataRequest, callback func(response *DescribeJobMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobMetricDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeJobMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobMetricDataRequest is the request struct for api DescribeJobMetricData
type DescribeJobMetricDataRequest struct {
	*requests.RpcRequest
	TaskName   string    `position:"Query" name:"TaskName"`
	JobId      string    `position:"Query" name:"JobId"`
	MetricName string    `position:"Query" name:"MetricName"`
	ArrayIndex *[]string `position:"Query" name:"ArrayIndex"  type:"Json"`
}

// DescribeJobMetricDataResponse is the response struct for api DescribeJobMetricData
type DescribeJobMetricDataResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Period     int    `json:"Period" xml:"Period"`
	DataPoints string `json:"DataPoints" xml:"DataPoints"`
}

// CreateDescribeJobMetricDataRequest creates a request to invoke DescribeJobMetricData API
func CreateDescribeJobMetricDataRequest() (request *DescribeJobMetricDataRequest) {
	request = &DescribeJobMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EhpcInstant", "2023-07-01", "DescribeJobMetricData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeJobMetricDataResponse creates a response to parse from DescribeJobMetricData response
func CreateDescribeJobMetricDataResponse() (response *DescribeJobMetricDataResponse) {
	response = &DescribeJobMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
