package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSubnet invokes the eflo.CreateSubnet API synchronously
func (client *Client) CreateSubnet(request *CreateSubnetRequest) (response *CreateSubnetResponse, err error) {
	response = CreateCreateSubnetResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSubnetWithChan invokes the eflo.CreateSubnet API asynchronously
func (client *Client) CreateSubnetWithChan(request *CreateSubnetRequest) (<-chan *CreateSubnetResponse, <-chan error) {
	responseChan := make(chan *CreateSubnetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSubnet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSubnetWithCallback invokes the eflo.CreateSubnet API asynchronously
func (client *Client) CreateSubnetWithCallback(request *CreateSubnetRequest, callback func(response *CreateSubnetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSubnetResponse
		var err error
		defer close(result)
		response, err = client.CreateSubnet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSubnetRequest is the request struct for api CreateSubnet
type CreateSubnetRequest struct {
	*requests.RpcRequest
	Type       string             `position:"Body" name:"Type"`
	Cidr       string             `position:"Body" name:"Cidr"`
	Tag        *[]CreateSubnetTag `position:"Body" name:"Tag"  type:"Repeated"`
	VpdId      string             `position:"Body" name:"VpdId"`
	ZoneId     string             `position:"Body" name:"ZoneId"`
	SubnetName string             `position:"Body" name:"SubnetName"`
}

// CreateSubnetTag is a repeated param struct in CreateSubnetRequest
type CreateSubnetTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateSubnetResponse is the response struct for api CreateSubnet
type CreateSubnetResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateCreateSubnetRequest creates a request to invoke CreateSubnet API
func CreateCreateSubnetRequest() (request *CreateSubnetRequest) {
	request = &CreateSubnetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "CreateSubnet", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSubnetResponse creates a response to parse from CreateSubnet response
func CreateCreateSubnetResponse() (response *CreateSubnetResponse) {
	response = &CreateSubnetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
