package eflo_controller

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterNodes invokes the eflo_controller.ListClusterNodes API synchronously
func (client *Client) ListClusterNodes(request *ListClusterNodesRequest) (response *ListClusterNodesResponse, err error) {
	response = CreateListClusterNodesResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterNodesWithChan invokes the eflo_controller.ListClusterNodes API asynchronously
func (client *Client) ListClusterNodesWithChan(request *ListClusterNodesRequest) (<-chan *ListClusterNodesResponse, <-chan error) {
	responseChan := make(chan *ListClusterNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterNodesWithCallback invokes the eflo_controller.ListClusterNodes API asynchronously
func (client *Client) ListClusterNodesWithCallback(request *ListClusterNodesRequest, callback func(response *ListClusterNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterNodesResponse
		var err error
		defer close(result)
		response, err = client.ListClusterNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterNodesRequest is the request struct for api ListClusterNodes
type ListClusterNodesRequest struct {
	*requests.RpcRequest
	ClusterId   string           `position:"Body" name:"ClusterId"`
	NodeGroupId string           `position:"Body" name:"NodeGroupId"`
	NextToken   string           `position:"Body" name:"NextToken"`
	MaxResults  requests.Integer `position:"Body" name:"MaxResults"`
}

// ListClusterNodesResponse is the response struct for api ListClusterNodes
type ListClusterNodesResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	NextToken string      `json:"NextToken" xml:"NextToken"`
	Nodes     []NodesItem `json:"Nodes" xml:"Nodes"`
}

// CreateListClusterNodesRequest creates a request to invoke ListClusterNodes API
func CreateListClusterNodesRequest() (request *ListClusterNodesRequest) {
	request = &ListClusterNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo-controller", "2022-12-15", "ListClusterNodes", "", "")
	request.Method = requests.POST
	return
}

// CreateListClusterNodesResponse creates a response to parse from ListClusterNodes response
func CreateListClusterNodesResponse() (response *ListClusterNodesResponse) {
	response = &ListClusterNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
