package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTaskFlow invokes the dms_enterprise.CreateTaskFlow API synchronously
func (client *Client) CreateTaskFlow(request *CreateTaskFlowRequest) (response *CreateTaskFlowResponse, err error) {
	response = CreateCreateTaskFlowResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTaskFlowWithChan invokes the dms_enterprise.CreateTaskFlow API asynchronously
func (client *Client) CreateTaskFlowWithChan(request *CreateTaskFlowRequest) (<-chan *CreateTaskFlowResponse, <-chan error) {
	responseChan := make(chan *CreateTaskFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTaskFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTaskFlowWithCallback invokes the dms_enterprise.CreateTaskFlow API asynchronously
func (client *Client) CreateTaskFlowWithCallback(request *CreateTaskFlowRequest, callback func(response *CreateTaskFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTaskFlowResponse
		var err error
		defer close(result)
		response, err = client.CreateTaskFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTaskFlowRequest is the request struct for api CreateTaskFlow
type CreateTaskFlowRequest struct {
	*requests.RpcRequest
	DagName     string           `position:"Query" name:"DagName"`
	Description string           `position:"Query" name:"Description"`
	Tid         requests.Integer `position:"Query" name:"Tid"`
	ScenarioId  requests.Integer `position:"Query" name:"ScenarioId"`
}

// CreateTaskFlowResponse is the response struct for api CreateTaskFlow
type CreateTaskFlowResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	DagId        int64  `json:"DagId" xml:"DagId"`
}

// CreateCreateTaskFlowRequest creates a request to invoke CreateTaskFlow API
func CreateCreateTaskFlowRequest() (request *CreateTaskFlowRequest) {
	request = &CreateTaskFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateTaskFlow", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTaskFlowResponse creates a response to parse from CreateTaskFlow response
func CreateCreateTaskFlowResponse() (response *CreateTaskFlowResponse) {
	response = &CreateTaskFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
