package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccessRule invokes the dfs.DeleteAccessRule API synchronously
func (client *Client) DeleteAccessRule(request *DeleteAccessRuleRequest) (response *DeleteAccessRuleResponse, err error) {
	response = CreateDeleteAccessRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAccessRuleWithChan invokes the dfs.DeleteAccessRule API asynchronously
func (client *Client) DeleteAccessRuleWithChan(request *DeleteAccessRuleRequest) (<-chan *DeleteAccessRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteAccessRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccessRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAccessRuleWithCallback invokes the dfs.DeleteAccessRule API asynchronously
func (client *Client) DeleteAccessRuleWithCallback(request *DeleteAccessRuleRequest, callback func(response *DeleteAccessRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAccessRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccessRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAccessRuleRequest is the request struct for api DeleteAccessRule
type DeleteAccessRuleRequest struct {
	*requests.RpcRequest
	AccessGroupId string `position:"Query" name:"AccessGroupId"`
	InputRegionId string `position:"Query" name:"InputRegionId"`
	AccessRuleId  string `position:"Query" name:"AccessRuleId"`
}

// DeleteAccessRuleResponse is the response struct for api DeleteAccessRule
type DeleteAccessRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAccessRuleRequest creates a request to invoke DeleteAccessRule API
func CreateDeleteAccessRuleRequest() (request *DeleteAccessRuleRequest) {
	request = &DeleteAccessRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "DeleteAccessRule", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAccessRuleResponse creates a response to parse from DeleteAccessRule response
func CreateDeleteAccessRuleResponse() (response *DeleteAccessRuleResponse) {
	response = &DeleteAccessRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
